/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile;

import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Logger;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFactorySpi;
import org.geotools.data.directory.DirectoryDataStore;
import org.geotools.data.directory.FileStoreFactory;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.files.ShpFiles;
import org.geotools.util.KVP;
import org.geotools.util.URLs;
import org.geotools.util.logging.Logging;

public class ShapefileDataStoreFactory
implements FileDataStoreFactorySpi {
    static final Logger LOGGER = Logging.getLogger(ShapefileDataStoreFactory.class);
    public static final DataAccessFactory.Param URLP = new DataAccessFactory.Param("url", URL.class, "url to a .shp file", true, null, new KVP("ext", "shp"));
    public static final DataAccessFactory.Param NAMESPACEP = new DataAccessFactory.Param("namespace", URI.class, "uri to a the namespace", false, null, new KVP("level", "advanced"));
    public static final DataAccessFactory.Param MEMORY_MAPPED = new DataAccessFactory.Param("memory mapped buffer", Boolean.class, "enable/disable the use of memory-mapped io", false, (Object)false, new KVP("level", "advanced"));
    public static final DataAccessFactory.Param CACHE_MEMORY_MAPS = new DataAccessFactory.Param("cache and reuse memory maps", Boolean.class, "only memory map a file one, then cache and reuse the map", false, (Object)true, new KVP("level", "advanced"));
    public static final DataAccessFactory.Param FILE_TYPE = new DataAccessFactory.Param("filetype", String.class, "Discriminator for directory stores", false, (Object)"shapefile", new KVP("level", "program"));
    public static final DataAccessFactory.Param CREATE_SPATIAL_INDEX = new DataAccessFactory.Param("create spatial index", Boolean.class, "enable/disable the automatic creation of spatial index", false, (Object)true, new KVP("level", "advanced"));
    public static final DataAccessFactory.Param DBFCHARSET = new DataAccessFactory.Param("charset", (Class)Charset.class, "character used to decode strings from the DBF file", false, (Object)Charset.forName("ISO-8859-1"), (Map)new KVP("level", "advanced")){

        @Override
        public Object parse(String text) throws IOException {
            return Charset.forName(text);
        }

        @Override
        public String text(Object value) {
            return ((Charset)value).name();
        }
    };
    public static final DataAccessFactory.Param FSTYPE = new DataAccessFactory.Param("fstype", String.class, "Enable using a setting of 'shape'.", false, (Object)"shape", new KVP("level", "advanced", "options", Arrays.asList("shape-ng", "shape", "index")));
    public static final DataAccessFactory.Param DBFTIMEZONE = new DataAccessFactory.Param("timezone", (Class)TimeZone.class, "time zone used to read dates from the DBF file", false, (Object)TimeZone.getDefault(), (Map)new KVP("level", "advanced")){

        @Override
        public Object parse(String text) throws IOException {
            return TimeZone.getTimeZone(text);
        }

        @Override
        public String text(Object value) {
            return ((TimeZone)value).getID();
        }
    };
    public static final DataAccessFactory.Param ENABLE_SPATIAL_INDEX = new DataAccessFactory.Param("enable spatial index", Boolean.class, "enable/disable the use of spatial index for local shapefiles", false, (Object)true, new KVP("level", "advanced"));

    @Override
    public String getDisplayName() {
        return "Shapefile";
    }

    @Override
    public String getDescription() {
        return "ESRI(tm) Shapefiles (*.shp)";
    }

    @Override
    public DataAccessFactory.Param[] getParametersInfo() {
        return new DataAccessFactory.Param[]{URLP, NAMESPACEP, ENABLE_SPATIAL_INDEX, CREATE_SPATIAL_INDEX, DBFCHARSET, DBFTIMEZONE, MEMORY_MAPPED, CACHE_MEMORY_MAPS, FILE_TYPE, FSTYPE};
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return Collections.EMPTY_MAP;
    }

    @Override
    public DataStore createDataStore(Map<String, Serializable> params) throws IOException {
        File dir;
        URL url = this.lookup(URLP, params, URL.class);
        Boolean isMemoryMapped = this.lookup(MEMORY_MAPPED, params, Boolean.class);
        Boolean cacheMemoryMaps = this.lookup(CACHE_MEMORY_MAPS, params, Boolean.class);
        URI namespace = this.lookup(NAMESPACEP, params, URI.class);
        Charset dbfCharset = this.lookup(DBFCHARSET, params, Charset.class);
        TimeZone dbfTimeZone = this.lookup(DBFTIMEZONE, params, TimeZone.class);
        Boolean isCreateSpatialIndex = this.lookup(CREATE_SPATIAL_INDEX, params, Boolean.class);
        Boolean isEnableSpatialIndex = (Boolean)ENABLE_SPATIAL_INDEX.lookUp(params);
        if (isEnableSpatialIndex == null) {
            isEnableSpatialIndex = Boolean.TRUE;
        }
        if ((dir = URLs.urlToFile(url)) != null && dir.isDirectory()) {
            return new DirectoryDataStore(URLs.urlToFile(url), new ShpFileStoreFactory(this, params));
        }
        ShpFiles shpFiles = new ShpFiles(url);
        boolean isLocal = shpFiles.isLocal();
        boolean useMemoryMappedBuffer = isLocal && isMemoryMapped != false;
        boolean enableIndex = isEnableSpatialIndex != false && isLocal;
        boolean createIndex = isCreateSpatialIndex != false && enableIndex;
        ShapefileDataStore store = new ShapefileDataStore(url);
        if (namespace != null) {
            store.setNamespaceURI(namespace.toString());
        }
        store.setMemoryMapped(useMemoryMappedBuffer);
        store.setBufferCachingEnabled(cacheMemoryMaps);
        store.setCharset(dbfCharset);
        store.setTimeZone(dbfTimeZone);
        store.setIndexed(enableIndex);
        store.setIndexCreationEnabled(createIndex);
        return store;
    }

    @Override
    public DataStore createNewDataStore(Map<String, Serializable> params) throws IOException {
        return this.createDataStore((Map)params);
    }

    <T> T lookup(DataAccessFactory.Param param, Map<String, Serializable> params, Class<T> target) throws IOException {
        Object result = param.lookUp(params);
        if (result == null) {
            return param.getDefaultValue();
        }
        return (T)result;
    }

    public boolean canProcess(Map params) {
        if (!DataUtilities.canProcess(params, this.getParametersInfo())) {
            return false;
        }
        try {
            URL url = (URL)URLP.lookUp(params);
            if (this.canProcess(url)) {
                return true;
            }
            Object fileType = FILE_TYPE.lookUp(params);
            File dir = URLs.urlToFile(url);
            if (dir != null && dir.isDirectory() && fileType == null) {
                String dirPath = dir.getPath();
                String[] vpfTables = new String[]{"LAT", "LHT", "DHT", "lat", "lht", "dht"};
                for (int itab = 0; itab < vpfTables.length; ++itab) {
                    String tabFilename = vpfTables[itab];
                    String pathTab = dirPath.concat(File.separator).concat(tabFilename);
                    if (!new File(pathTab).exists()) continue;
                    return false;
                }
            }
            return dir != null && dir.isDirectory() && (fileType == null || "shapefile".equals(fileType));
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean canProcess(URL f) {
        return f != null && f.getFile().toUpperCase().endsWith("SHP");
    }

    @Override
    public String[] getFileExtensions() {
        return new String[]{".shp"};
    }

    @Override
    public FileDataStore createDataStore(URL url) throws IOException {
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put(ShapefileDataStoreFactory.URLP.key, url);
        boolean isLocal = url.getProtocol().equalsIgnoreCase("file");
        File file = URLs.urlToFile(url);
        if (file != null && file.isDirectory()) {
            return null;
        }
        if (isLocal && !file.exists()) {
            return (FileDataStore)this.createNewDataStore(params);
        }
        return (FileDataStore)this.createDataStore(params);
    }

    @Override
    public String getTypeName(URL url) throws IOException {
        FileDataStore ds = this.createDataStore(url);
        String[] names = ds.getTypeNames();
        ds.dispose();
        return names == null || names.length == 0 ? null : names[0];
    }

    public static class ShpFileStoreFactory
    implements FileStoreFactory {
        ShapefileDataStoreFactory shpFactory;
        Map originalParams;

        public ShpFileStoreFactory(ShapefileDataStoreFactory factory, Map originalParams) {
            this.shpFactory = factory;
            this.originalParams = originalParams;
        }

        @Override
        public DataStore getDataStore(File file) throws IOException {
            URL url = URLs.fileToUrl(file);
            if (this.shpFactory.canProcess(url)) {
                HashMap<String, URL> params = new HashMap<String, URL>(this.originalParams);
                params.put(ShapefileDataStoreFactory.URLP.key, url);
                return this.shpFactory.createDataStore(params);
            }
            return null;
        }
    }
}

