/*
 * Decompiled with CFR 0.152.
 */
package ext_tools.preferences;

import ext_tools.ExtTool;
import ext_tools.ToolsInformation;
import ext_tools.preferences.EditToolDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class MyToolsPanel
extends JPanel {
    private final transient ToolsInformation tools;

    public MyToolsPanel(ToolsInformation tools) {
        super(new GridBagLayout());
        this.tools = tools;
    }

    public void refresh() {
        this.removeAll();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 5, 2, 5);
        for (ExtTool tool : this.tools.getToolsList()) {
            gbc.gridx = 0;
            gbc.weightx = 1.0;
            gbc.anchor = 17;
            JCheckBox cbTool = new JCheckBox(tool.getName());
            cbTool.setSelected(tool.isEnabled());
            cbTool.addActionListener(e -> tool.setEnabled(cbTool.isSelected()));
            this.add((Component)cbTool, gbc);
            gbc.gridx = 1;
            gbc.weightx = 0.0;
            gbc.anchor = 13;
            JButton bEdit = new JButton(I18n.tr((String)"Edit", (Object[])new Object[0]));
            bEdit.addActionListener(e -> {
                EditToolDialog dlg = new EditToolDialog(tool);
                ((Dialog)((Object)dlg)).setVisible(true);
                ((Window)((Object)dlg)).dispose();
                this.refresh();
            });
            this.add((Component)bEdit, gbc);
            gbc.gridx = 2;
            JButton bDel = new JButton("X");
            bDel.addActionListener(e -> {
                if (JOptionPane.showConfirmDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Delete tool \"{0}\"?", (Object[])new Object[]{tool.name}), I18n.tr((String)"Are you sure?", (Object[])new Object[0]), 0, 3) == 0) {
                    this.tools.removeTool(tool);
                    this.refresh();
                }
            });
            this.add((Component)bDel, gbc);
            ++gbc.gridy;
        }
        gbc.gridx = 0;
        gbc.fill = 0;
        gbc.anchor = 17;
        JButton bNew = new JButton(I18n.tr((String)"New tool...", (Object[])new Object[0]));
        bNew.addActionListener(e -> {
            ExtTool tool = new ExtTool();
            EditToolDialog dlg = new EditToolDialog(tool);
            ((Dialog)((Object)dlg)).setVisible(true);
            ((Window)((Object)dlg)).dispose();
            if (!Utils.isStripEmpty((String)tool.name)) {
                this.tools.addTool(tool);
                tool.setEnabled(true);
            }
            this.refresh();
        });
        this.add((Component)bNew, gbc);
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add((Component)new JPanel(), gbc);
        this.revalidate();
        this.repaint();
    }
}

