/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.commandline;

import java.awt.AWTEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.GeneralPath;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.preferences.NamedColorProperty;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.commandline.CommandLine;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

public class LengthAction
extends MapMode
implements MapViewPaintable,
AWTEventListener {
    private final CommandLine parentPlugin;
    private final Cursor cursorCrosshair;
    private final Cursor cursorJoinNode;
    private Cursor currentCursor;
    private final Color selectedColor;
    private Point drawStartPos;
    private Point drawEndPos;
    private LatLon startCoor;
    private LatLon endCoor;
    private Point mousePos;
    private Node nearestNode;
    private boolean drawing;

    public LengthAction(CommandLine parentPlugin) {
        super(null, "addsegment", null, ImageProvider.getCursor((String)"crosshair", null));
        this.parentPlugin = parentPlugin;
        this.selectedColor = new NamedColorProperty(I18n.marktr((String)"selected"), Color.red).get();
        this.cursorCrosshair = ImageProvider.getCursor((String)"crosshair", null);
        this.cursorJoinNode = ImageProvider.getCursor((String)"crosshair", (String)"joinnode");
        this.currentCursor = this.cursorCrosshair;
        this.nearestNode = null;
    }

    public void enterMode() {
        super.enterMode();
        MapView mapView = MainApplication.getMap().mapView;
        mapView.addMouseListener((MouseListener)((Object)this));
        mapView.addMouseMotionListener((MouseMotionListener)((Object)this));
        mapView.addTemporaryLayer((MapViewPaintable)this);
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        }
        catch (SecurityException ex) {
            Logging.warn((Throwable)ex);
        }
    }

    public void exitMode() {
        super.exitMode();
        MapView mapView = MainApplication.getMap().mapView;
        mapView.removeMouseListener((MouseListener)((Object)this));
        mapView.removeMouseMotionListener((MouseMotionListener)((Object)this));
        mapView.removeTemporaryLayer((MapViewPaintable)this);
        try {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }
        catch (SecurityException ex) {
            Logging.warn((Throwable)ex);
        }
        if (this.drawing) {
            mapView.repaint();
        }
    }

    public void cancelDrawing() {
        MapFrame map = MainApplication.getMap();
        if (map == null || map.mapView == null) {
            return;
        }
        map.statusLine.setHeading(-1.0);
        map.statusLine.setAngle(-1.0);
        this.updateStatusLine();
        this.parentPlugin.abortInput();
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        if (!(event instanceof KeyEvent)) {
            return;
        }
        KeyEvent ev = (KeyEvent)event;
        if (ev.getKeyCode() == 27 && ev.getID() == 401) {
            if (this.drawing) {
                ev.consume();
            }
            this.cancelDrawing();
        }
    }

    private void processMouseEvent(MouseEvent e) {
        if (e != null) {
            this.mousePos = e.getPoint();
        }
    }

    public void paint(Graphics2D g, MapView mv, Bounds bbox) {
        if (!this.drawing) {
            return;
        }
        g.setColor(this.selectedColor);
        g.setStroke(new BasicStroke(3.0f, 1, 1));
        GeneralPath b = new GeneralPath();
        Point pp1 = this.drawStartPos;
        Point pp2 = this.drawEndPos;
        b.moveTo(pp1.x, pp1.y);
        b.lineTo(pp2.x, pp2.y);
        g.draw(b);
        g.setStroke(new BasicStroke(1.0f));
    }

    private void drawingStart(MouseEvent e) {
        this.mousePos = e.getPoint();
        this.drawStartPos = this.nearestNode != null ? MainApplication.getMap().mapView.getPoint(this.nearestNode.getCoor()) : this.mousePos;
        this.drawEndPos = this.drawStartPos;
        this.endCoor = this.startCoor = MainApplication.getMap().mapView.getLatLon(this.drawStartPos.x, this.drawStartPos.y);
        this.drawing = true;
        this.updateStatusLine();
    }

    private void drawingFinish() {
        this.parentPlugin.loadParameter(String.valueOf(this.startCoor.greatCircleDistance(this.endCoor)), true);
        this.drawStartPos = null;
        this.drawing = false;
        this.exitMode();
    }

    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            if (!MainApplication.getMap().mapView.isActiveLayerDrawable()) {
                return;
            }
            this.requestFocusInMapView();
            this.drawingStart(e);
        } else {
            this.drawing = false;
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        if (!MainApplication.getMap().mapView.isActiveLayerDrawable()) {
            return;
        }
        boolean dragged = true;
        if (this.drawStartPos != null) {
            boolean bl = dragged = this.drawEndPos.distance(this.drawStartPos) > 10.0;
        }
        if (this.drawing && dragged) {
            this.drawingFinish();
        }
        this.drawing = false;
    }

    public void mouseDragged(MouseEvent e) {
        this.processMouseEvent(e);
        this.updCursor();
        MapFrame map = MainApplication.getMap();
        this.drawEndPos = this.nearestNode != null ? map.mapView.getPoint(this.nearestNode.getCoor()) : this.mousePos;
        this.endCoor = map.mapView.getLatLon(this.drawEndPos.x, this.drawEndPos.y);
        if (this.drawing) {
            map.statusLine.setDist(this.startCoor.greatCircleDistance(this.endCoor));
            map.mapView.repaint();
        }
    }

    public void mouseMoved(MouseEvent e) {
        if (!MainApplication.getMap().mapView.isActiveLayerDrawable()) {
            return;
        }
        this.processMouseEvent(e);
        this.updCursor();
        if (this.drawing) {
            MainApplication.getMap().mapView.repaint();
        }
    }

    public String getModeHelpText() {
        if (this.drawing) {
            return I18n.tr((String)"Point on the start", (Object[])new Object[0]);
        }
        return I18n.tr((String)"Point on the end", (Object[])new Object[0]);
    }

    public boolean layerIsSupported(Layer l) {
        return l instanceof OsmDataLayer;
    }

    private void updCursor() {
        if (this.mousePos != null) {
            if (!MainApplication.isDisplayingMapView()) {
                return;
            }
            this.nearestNode = MainApplication.getMap().mapView.getNearestNode(this.mousePos, AbstractPrimitive::isUsable);
            if (this.nearestNode != null) {
                this.setCursor(this.cursorJoinNode);
            } else {
                this.setCursor(this.cursorCrosshair);
            }
        }
    }

    private void setCursor(Cursor c) {
        if (this.currentCursor.equals(c)) {
            return;
        }
        try {
            EventQueue.invokeLater(() -> {
                if (!(MainApplication.getMap().mapMode instanceof LengthAction)) {
                    return;
                }
                MainApplication.getMap().mapView.setCursor(c);
            });
            this.currentCursor = c;
        }
        catch (Exception e) {
            Logging.warn((Throwable)e);
        }
    }
}

