/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fr.cadastre.edigeo;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.plugins.fr.cadastre.download.CadastreDownloadData;
import org.openstreetmap.josm.plugins.fr.cadastre.edigeo.EdigeoCharset;
import org.openstreetmap.josm.plugins.fr.cadastre.edigeo.EdigeoRecord;
import org.openstreetmap.josm.tools.Logging;

abstract class EdigeoFile {
    private static final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyyMMdd");
    protected final Path path;
    private boolean bomFound;
    private boolean eomFound;
    private EdigeoCharset charset;
    private Block currentBlock;

    EdigeoFile(Path path) {
        this.path = path;
    }

    public EdigeoFile read() throws IOException, ReflectiveOperationException {
        try (BufferedReader reader = Files.newBufferedReader(this.path, StandardCharsets.ISO_8859_1);){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty()) continue;
                EdigeoRecord r = new EdigeoRecord(line);
                if (!this.bomFound) {
                    this.bomFound = "BOM".equals(r.name);
                    if (!this.bomFound) {
                        throw new IOException("Unexpected first record: " + r);
                    }
                    assert (r.length == 12 && r.values.size() == 1) : r;
                    continue;
                }
                if (this.charset == null) {
                    if (!"CSE".equals(r.name)) {
                        throw new IOException("Unexpected record instead of charset: " + r);
                    }
                    assert (r.values.size() == 1) : r;
                    this.charset = EdigeoCharset.of(r.values.get(0));
                    continue;
                }
                if (this.eomFound) {
                    throw new IOException("Unexpected record after end of file: " + r);
                }
                this.eomFound = "EOM".equals(r.name);
                if (!this.eomFound) {
                    this.processRecord(r);
                    continue;
                }
                assert (r.length == 0 && r.values.isEmpty()) : r;
            }
        }
        return this;
    }

    protected abstract Block createBlock(String var1) throws ReflectiveOperationException;

    protected static <T extends Block> T addBlock(List<T> blocks, T block) {
        blocks.add(block);
        return block;
    }

    private void processRecord(EdigeoRecord r) throws ReflectiveOperationException {
        if ("RTY".equals(r.name)) {
            this.currentBlock = Objects.requireNonNull(this.createBlock(r.values.get(0)), r.toString());
            return;
        }
        if (this.currentBlock == null) {
            throw new IllegalStateException(r.toString());
        }
        this.currentBlock.processRecord(r);
    }

    abstract boolean isValid();

    void resolve() {
    }

    EdigeoFile fill(DataSet ds, CadastreDownloadData data) {
        return this;
    }

    static class Block {
        final String type;
        String identifier = "";
        private Consumer<String> lastReadString;

        Block(String type) {
            this.type = Objects.requireNonNull(type, "type");
        }

        public final String getBlockType() {
            return this.type;
        }

        public final String getBlockIdentifier() {
            return this.identifier;
        }

        void processRecord(EdigeoRecord r) {
            if ("RID".equals(r.name)) {
                this.safeGet(r, (String s) -> {
                    this.identifier = this.identifier + s;
                });
            } else if ("NEX".equals(r.name) && this.lastReadString != null) {
                this.safeGet(r, this.lastReadString);
            } else {
                throw new IllegalArgumentException(r.toString());
            }
        }

        static boolean areNotNull(Object ... objects) {
            return Arrays.stream(objects).noneMatch(o -> o == null);
        }

        static boolean areNotEmpty(String ... strings) {
            return Block.areNotNull(strings) && Arrays.stream(strings).noneMatch(String::isEmpty);
        }

        static boolean areSameSize(int size, Collection<?> ... collections) {
            return Block.areNotNull(collections) && Arrays.stream(collections).allMatch(c -> c.size() == size);
        }

        boolean isValid() {
            return this.type.length() == 3 && Block.areNotEmpty(this.identifier);
        }

        void resolvePhase1() {
        }

        void resolvePhase2() {
        }

        protected final void safeGet(EdigeoRecord r, List<String> list) {
            list.add("");
            this.safeGet(r, (String s) -> {
                int idx = list.size() - 1;
                list.set(idx, (String)list.get(idx) + s);
            });
        }

        protected final void safeGet(EdigeoRecord r, Consumer<String> callback) {
            this.lastReadString = callback;
            this.lastReadString.accept(r.length > 0 ? r.values.get(0) : null);
        }

        protected final char safeGetChar(EdigeoRecord r) {
            return r.length > 0 ? r.values.get(0).charAt(0) : (char)'\u0000';
        }

        protected final int safeGetInt(EdigeoRecord r) {
            return r.length > 0 ? Integer.parseInt(r.values.get(0)) : 0;
        }

        protected final LocalDate safeGetDate(EdigeoRecord r) {
            return r.length > 0 ? LocalDate.parse(r.values.get(0), dateFormatter) : null;
        }

        protected final double safeGetDouble(EdigeoRecord r) {
            return r.length > 0 ? Double.parseDouble(r.values.get(0)) : 0.0;
        }

        protected final EastNorth safeGetEastNorth(EdigeoRecord r) {
            return r.length > 0 ? new EastNorth(Double.parseDouble(r.values.get(0)), Double.parseDouble(r.values.get(1))) : null;
        }

        protected final void safeGetAndLog(EdigeoRecord r, Consumer<String> callback, String msg) {
            if (r.length > 0) {
                String v = r.values.get(0);
                Logging.info((String)(msg + ": " + v));
                this.lastReadString = callback;
                this.lastReadString.accept(v);
            }
        }

        protected final LocalDate safeGetDateAndLog(EdigeoRecord r, String msg) {
            if (r.length > 0) {
                LocalDate v = LocalDate.parse(r.values.get(0), dateFormatter);
                Logging.info((String)(msg + ": " + v));
                return v;
            }
            return null;
        }
    }
}

