/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fr.cadastre.wms;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.plugins.fr.cadastre.CadastrePlugin;
import org.openstreetmap.josm.plugins.fr.cadastre.wms.CacheControl;
import org.openstreetmap.josm.plugins.fr.cadastre.wms.CadastreGrabber;
import org.openstreetmap.josm.plugins.fr.cadastre.wms.EastNorthBound;
import org.openstreetmap.josm.plugins.fr.cadastre.wms.GeorefImage;
import org.openstreetmap.josm.plugins.fr.cadastre.wms.WMSLayer;
import org.openstreetmap.josm.tools.Logging;

public class GrabThread
extends Thread {
    private boolean canceled;
    private CadastreGrabber grabber;
    private WMSLayer wmsLayer;
    private Lock lockImagesToGrag = new ReentrantLock();
    private ArrayList<EastNorthBound> imagesToGrab = new ArrayList();
    private CacheControl cacheControl = null;
    private EastNorthBound currentGrabImage;
    private Lock lockCurrentGrabImage = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addImages(ArrayList<EastNorthBound> moreImages) {
        this.lockImagesToGrag.lock();
        try {
            this.imagesToGrab.addAll(moreImages);
        }
        finally {
            this.lockImagesToGrag.unlock();
        }
        GrabThread grabThread = this;
        synchronized (grabThread) {
            this.notify();
        }
        Logging.info((String)("Added " + moreImages.size() + " to the grab thread"));
        if (this.wmsLayer.isRaster()) {
            this.waitNotification();
        }
    }

    public int getImagesToGrabSize() {
        this.lockImagesToGrag.lock();
        try {
            int n = this.imagesToGrab.size();
            return n;
        }
        finally {
            this.lockImagesToGrag.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayList<EastNorthBound> getImagesToGrabCopy() {
        ArrayList<EastNorthBound> copyList = new ArrayList<EastNorthBound>();
        this.lockImagesToGrag.lock();
        try {
            for (EastNorthBound img : this.imagesToGrab) {
                EastNorthBound imgCpy = new EastNorthBound(img.min, img.max);
                copyList.add(imgCpy);
            }
        }
        finally {
            this.lockImagesToGrag.unlock();
        }
        return copyList;
    }

    void clearImagesToGrab() {
        this.lockImagesToGrag.lock();
        try {
            this.imagesToGrab.clear();
        }
        finally {
            this.lockImagesToGrag.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            block18: {
                if (this.getImagesToGrabSize() > 0) {
                    this.lockImagesToGrag.lock();
                    this.lockCurrentGrabImage.lock();
                    this.currentGrabImage = this.imagesToGrab.get(0);
                    this.lockCurrentGrabImage.unlock();
                    this.imagesToGrab.remove(0);
                    this.lockImagesToGrag.unlock();
                    if (!this.canceled) {
                        GeorefImage newImage;
                        try {
                            this.wmsLayer.invalidate();
                            newImage = this.grabber.grab(this.wmsLayer, this.currentGrabImage.min, this.currentGrabImage.max);
                        }
                        catch (IOException e) {
                            Logging.warn((String)"Download action canceled by user or server did not respond");
                            this.setCanceled(true);
                            break block18;
                        }
                        catch (OsmTransferException e) {
                            Logging.error((String)"OSM transfer failed");
                            this.setCanceled(true);
                            break block18;
                        }
                        if (this.grabber.getWmsInterface().downloadCanceled) {
                            Logging.info((String)"Download action canceled by user");
                            this.setCanceled(true);
                        } else {
                            try {
                                if (CadastrePlugin.backgroundTransparent) {
                                    this.wmsLayer.imagesLock.lock();
                                    try {
                                        for (GeorefImage img : this.wmsLayer.getImages()) {
                                            if (img.overlap(newImage)) {
                                                img.withdraw(newImage);
                                                continue;
                                            }
                                            newImage.withdraw(img);
                                        }
                                    }
                                    finally {
                                        this.wmsLayer.imagesLock.unlock();
                                    }
                                }
                                this.wmsLayer.addImage(newImage);
                                this.wmsLayer.invalidate();
                                this.saveToCache(newImage);
                            }
                            catch (NullPointerException e) {
                                Logging.info((String)"Layer destroyed. Cancel grab thread");
                                this.setCanceled(true);
                            }
                            continue;
                        }
                    }
                }
            }
            Logging.info((String)"grab thread list empty");
            this.lockCurrentGrabImage.lock();
            this.currentGrabImage = null;
            this.lockCurrentGrabImage.unlock();
            if (this.canceled) {
                this.clearImagesToGrab();
                this.canceled = false;
            }
            if (this.wmsLayer.isRaster()) {
                this.notifyWaiter();
            }
            this.waitNotification();
        }
    }

    void saveToCache(GeorefImage image) {
        if (CacheControl.cacheEnabled && !this.wmsLayer.isRaster()) {
            this.getCacheControl().saveCache(image);
        }
    }

    public void saveNewCache() {
        if (CacheControl.cacheEnabled) {
            this.getCacheControl().deleteCacheFile();
            this.wmsLayer.imagesLock.lock();
            for (GeorefImage image : this.wmsLayer.getImages()) {
                this.getCacheControl().saveCache(image);
            }
            this.wmsLayer.imagesLock.unlock();
        }
    }

    public void cancel() {
        this.clearImagesToGrab();
        if (this.cacheControl != null) {
            while (!this.cacheControl.isCachePipeEmpty()) {
                Logging.info((String)"Try to close a WMSLayer which is currently saving in cache : wait 1 sec.");
                CadastrePlugin.safeSleep(1000L);
            }
        }
    }

    public CacheControl getCacheControl() {
        if (this.cacheControl == null) {
            this.cacheControl = new CacheControl(this.wmsLayer);
        }
        return this.cacheControl;
    }

    GrabThread(WMSLayer wmsLayer) {
        this.wmsLayer = wmsLayer;
    }

    void paintBoxesToGrab(Graphics g, MapView mv) {
        if (this.getImagesToGrabSize() > 0) {
            ArrayList<EastNorthBound> imagesToGrab = this.getImagesToGrabCopy();
            for (EastNorthBound img : imagesToGrab) {
                this.paintBox(g, mv, img, Color.red);
            }
        }
        this.lockCurrentGrabImage.lock();
        if (this.currentGrabImage != null) {
            this.paintBox(g, mv, this.currentGrabImage, Color.orange);
        }
        this.lockCurrentGrabImage.unlock();
    }

    private void paintBox(Graphics g, MapView mv, EastNorthBound img, Color color) {
        Point[] croppedPoint;
        croppedPoint = new Point[]{mv.getPoint(img.min), mv.getPoint(new EastNorth(img.min.east(), img.max.north())), mv.getPoint(img.max), mv.getPoint(new EastNorth(img.max.east(), img.min.north())), croppedPoint[0]};
        for (int i = 0; i < 4; ++i) {
            g.setColor(color);
            g.drawLine(croppedPoint[i].x, croppedPoint[i].y, croppedPoint[i + 1].x, croppedPoint[i + 1].y);
        }
    }

    boolean isCanceled() {
        return this.canceled;
    }

    void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    CadastreGrabber getGrabber() {
        return this.grabber;
    }

    void setGrabber(CadastreGrabber grabber) {
        this.grabber = grabber;
    }

    private synchronized void notifyWaiter() {
        this.notify();
    }

    private synchronized void waitNotification() {
        try {
            this.wait();
        }
        catch (InterruptedException e) {
            Logging.error((Throwable)e);
        }
    }
}

