/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

import org.apache.poi.util.LittleEndianConsts;

public class LittleEndian
implements LittleEndianConsts {
    private LittleEndian() {
    }

    public static short getShort(byte[] byArray, int n) {
        int n2 = byArray[n] & 0xFF;
        int n3 = byArray[n + 1] & 0xFF;
        return (short)((n3 << 8) + (n2 << 0));
    }

    public static int getUShort(byte[] byArray, int n) {
        int n2 = byArray[n] & 0xFF;
        int n3 = byArray[n + 1] & 0xFF;
        return (n3 << 8) + (n2 << 0);
    }

    public static int getUShort(byte[] byArray) {
        return LittleEndian.getUShort(byArray, 0);
    }

    public static int getInt(byte[] byArray, int n) {
        int n2 = n;
        int n3 = byArray[n2++] & 0xFF;
        int n4 = byArray[n2++] & 0xFF;
        int n5 = byArray[n2++] & 0xFF;
        int n6 = byArray[n2++] & 0xFF;
        return (n6 << 24) + (n5 << 16) + (n4 << 8) + (n3 << 0);
    }

    public static long getUInt(byte[] byArray, int n) {
        long l = LittleEndian.getInt(byArray, n);
        return l & 0xFFFFFFFFFFFFFFFFL;
    }

    public static long getLong(byte[] byArray, int n) {
        long l = 0L;
        for (int i = n + 8 - 1; i >= n; --i) {
            l <<= 8;
            l |= (long)(0xFF & byArray[i]);
        }
        return l;
    }

    public static double getDouble(byte[] byArray, int n) {
        return Double.longBitsToDouble(LittleEndian.getLong(byArray, n));
    }

    public static void putShort(byte[] byArray, int n, short s) {
        int n2 = n;
        byArray[n2++] = (byte)(s >>> 0 & 0xFF);
        byArray[n2++] = (byte)(s >>> 8 & 0xFF);
    }

    public static void putShort(byte[] byArray, short s) {
        LittleEndian.putShort(byArray, 0, s);
    }

    public static void putInt(byte[] byArray, int n, int n2) {
        int n3 = n;
        byArray[n3++] = (byte)(n2 >>> 0 & 0xFF);
        byArray[n3++] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n3++] = (byte)(n2 >>> 16 & 0xFF);
        byArray[n3++] = (byte)(n2 >>> 24 & 0xFF);
    }

    public static void putLong(byte[] byArray, int n, long l) {
        int n2 = 8 + n;
        long l2 = l;
        for (int i = n; i < n2; ++i) {
            byArray[i] = (byte)(l2 & 0xFFL);
            l2 >>= 8;
        }
    }

    public static void putDouble(byte[] byArray, int n, double d) {
        LittleEndian.putLong(byArray, n, Double.doubleToLongBits(d));
    }
}

