/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.format;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.ss.format.CellFormatType;

public class CellFormatPart {
    public static final Pattern SPECIFICATION_PAT;

    static String quoteSpecial(String string, CellFormatType cellFormatType) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\'' && cellFormatType.isSpecial('\'')) {
                stringBuilder.append('\u0000');
                continue;
            }
            boolean bl = cellFormatType.isSpecial(c);
            if (bl) {
                stringBuilder.append("'");
            }
            stringBuilder.append(c);
            if (!bl) continue;
            stringBuilder.append("'");
        }
        return stringBuilder.toString();
    }

    public static StringBuffer parseFormat(String string, CellFormatType cellFormatType, PartHandler partHandler) {
        Matcher matcher = SPECIFICATION_PAT.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String string2 = CellFormatPart.group(matcher, 0);
            if (string2.length() <= 0) continue;
            String string3 = partHandler.handlePart(matcher, string2, cellFormatType, stringBuffer);
            if (string3 == null) {
                switch (string2.charAt(0)) {
                    case '\"': {
                        string3 = CellFormatPart.quoteSpecial(string2.substring(1, string2.length() - 1), cellFormatType);
                        break;
                    }
                    case '\\': {
                        string3 = CellFormatPart.quoteSpecial(string2.substring(1), cellFormatType);
                        break;
                    }
                    case '_': {
                        string3 = " ";
                        break;
                    }
                    case '*': {
                        string3 = CellFormatPart.expandChar(string2);
                        break;
                    }
                    default: {
                        string3 = string2;
                    }
                }
            }
            matcher.appendReplacement(stringBuffer, Matcher.quoteReplacement(string3));
        }
        matcher.appendTail(stringBuffer);
        if (cellFormatType.isSpecial('\'')) {
            int n = 0;
            while ((n = stringBuffer.indexOf("''", n)) >= 0) {
                stringBuffer.delete(n, n + 2);
            }
            n = 0;
            while ((n = stringBuffer.indexOf("\u0000", n)) >= 0) {
                stringBuffer.replace(n, n + 1, "''");
            }
        }
        return stringBuffer;
    }

    static String expandChar(String string) {
        char c = string.charAt(1);
        String string2 = "" + c + c + c;
        return string2;
    }

    public static String group(Matcher matcher, int n) {
        String string = matcher.group(n);
        return string == null ? "" : string;
    }

    static {
        String string = "\\\\.                 # Quoted single character\n|\"([^\\\\\"]|\\\\.)*\"         # Quoted string of characters (handles escaped quotes like \\\") \n|_.                             # Space as wide as a given character\n|\\*.                           # Repeating fill character\n|@                              # Text: cell text\n|([0?\\#](?:[0?\\#,]*))         # Number: digit + other digits and commas\n|e[-+]                          # Number: Scientific: Exponent\n|m{1,5}                         # Date: month or minute spec\n|d{1,4}                         # Date: day/date spec\n|y{2,4}                         # Date: year spec\n|h{1,2}                         # Date: hour spec\n|s{1,2}                         # Date: second spec\n|am?/pm?                        # Date: am/pm spec\n|\\[h{1,2}\\]                   # Elapsed time: hour spec\n|\\[m{1,2}\\]                   # Elapsed time: minute spec\n|\\[s{1,2}\\]                   # Elapsed time: second spec\n|[^;]                           # A character\n";
        int n = 6;
        SPECIFICATION_PAT = Pattern.compile(string, n);
    }

    static interface PartHandler {
        public String handlePart(Matcher var1, String var2, CellFormatType var3, StringBuffer var4);
    }
}

