/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndianOutput;

public final class BOFRecord
extends StandardRecord {
    public static final short sid = 2057;
    public static final int TYPE_WORKBOOK = 5;
    public static final int TYPE_VB_MODULE = 6;
    public static final int TYPE_WORKSHEET = 16;
    public static final int TYPE_CHART = 32;
    public static final int TYPE_EXCEL_4_MACRO = 64;
    public static final int TYPE_WORKSPACE_FILE = 256;
    private int field_1_version;
    private int field_2_type;
    private int field_3_build;
    private int field_4_year;
    private int field_5_history;
    private int field_6_rversion;

    public BOFRecord() {
    }

    public BOFRecord(RecordInputStream recordInputStream) {
        this.field_1_version = recordInputStream.readShort();
        this.field_2_type = recordInputStream.readShort();
        if (recordInputStream.remaining() >= 2) {
            this.field_3_build = recordInputStream.readShort();
        }
        if (recordInputStream.remaining() >= 2) {
            this.field_4_year = recordInputStream.readShort();
        }
        if (recordInputStream.remaining() >= 4) {
            this.field_5_history = recordInputStream.readInt();
        }
        if (recordInputStream.remaining() >= 4) {
            this.field_6_rversion = recordInputStream.readInt();
        }
    }

    public void setVersion(int n) {
        this.field_1_version = n;
    }

    public void setType(int n) {
        this.field_2_type = n;
    }

    public void setBuild(int n) {
        this.field_3_build = n;
    }

    public void setBuildYear(int n) {
        this.field_4_year = n;
    }

    public void setHistoryBitMask(int n) {
        this.field_5_history = n;
    }

    public void setRequiredVersion(int n) {
        this.field_6_rversion = n;
    }

    public int getVersion() {
        return this.field_1_version;
    }

    public int getType() {
        return this.field_2_type;
    }

    public int getBuild() {
        return this.field_3_build;
    }

    public int getBuildYear() {
        return this.field_4_year;
    }

    public int getHistoryBitMask() {
        return this.field_5_history;
    }

    public int getRequiredVersion() {
        return this.field_6_rversion;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[BOF RECORD]\n");
        stringBuffer.append("    .version  = ").append(HexDump.shortToHex(this.getVersion())).append("\n");
        stringBuffer.append("    .type     = ").append(HexDump.shortToHex(this.getType()));
        stringBuffer.append(" (").append(this.getTypeName()).append(")").append("\n");
        stringBuffer.append("    .build    = ").append(HexDump.shortToHex(this.getBuild())).append("\n");
        stringBuffer.append("    .buildyear= ").append(this.getBuildYear()).append("\n");
        stringBuffer.append("    .history  = ").append(HexDump.intToHex(this.getHistoryBitMask())).append("\n");
        stringBuffer.append("    .reqver   = ").append(HexDump.intToHex(this.getRequiredVersion())).append("\n");
        stringBuffer.append("[/BOF RECORD]\n");
        return stringBuffer.toString();
    }

    private String getTypeName() {
        switch (this.field_2_type) {
            case 32: {
                return "chart";
            }
            case 64: {
                return "excel 4 macro";
            }
            case 6: {
                return "vb module";
            }
            case 5: {
                return "workbook";
            }
            case 16: {
                return "worksheet";
            }
            case 256: {
                return "workspace file";
            }
        }
        return "#error unknown type#";
    }

    @Override
    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this.getVersion());
        littleEndianOutput.writeShort(this.getType());
        littleEndianOutput.writeShort(this.getBuild());
        littleEndianOutput.writeShort(this.getBuildYear());
        littleEndianOutput.writeInt(this.getHistoryBitMask());
        littleEndianOutput.writeInt(this.getRequiredVersion());
    }

    @Override
    protected int getDataSize() {
        return 16;
    }

    @Override
    public short getSid() {
        return 2057;
    }

    @Override
    public Object clone() {
        BOFRecord bOFRecord = new BOFRecord();
        bOFRecord.field_1_version = this.field_1_version;
        bOFRecord.field_2_type = this.field_2_type;
        bOFRecord.field_3_build = this.field_3_build;
        bOFRecord.field_4_year = this.field_4_year;
        bOFRecord.field_5_history = this.field_5_history;
        bOFRecord.field_6_rversion = this.field_6_rversion;
        return bOFRecord;
    }
}

