/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.graphview.core.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.openstreetmap.josm.plugins.graphview.core.graph.EvaluationGroup;
import org.openstreetmap.josm.plugins.graphview.core.transition.Restriction;
import org.openstreetmap.josm.plugins.graphview.core.transition.Segment;
import org.openstreetmap.josm.plugins.graphview.core.transition.SegmentNode;
import org.openstreetmap.josm.tools.I18n;

public class ConnectorEvaluationGroup
extends EvaluationGroup {
    private final Set<Segment> segments;
    private final List<SegmentNode> borderNodes;

    public ConnectorEvaluationGroup(Set<Segment> segments, Set<SegmentNode> borderNodes) {
        assert (segments != null && borderNodes != null);
        this.segments = segments;
        this.borderNodes = new ArrayList<SegmentNode>(borderNodes);
    }

    public Collection<SegmentNode> getBorderNodes() {
        return this.borderNodes;
    }

    public Set<Segment> getSegments() {
        return this.segments;
    }

    public List<Segment> getSegmentSequence(SegmentNode startNode, SegmentNode targetNode) {
        assert (startNode != null && this.borderNodes.contains(startNode));
        assert (targetNode != null && this.borderNodes.contains(targetNode));
        if (!this.evaluated) {
            throw new IllegalStateException(I18n.tr((String)"Group not yet evaluated", (Object[])new Object[0]));
        }
        int inboundIndex = this.borderNodes.indexOf(startNode);
        int outboundIndex = this.borderNodes.indexOf(targetNode);
        return this.segmentSequences[inboundIndex][outboundIndex];
    }

    @Override
    protected void evaluateImpl(Collection<Restriction> restrictions) {
        List[][] sequenceArray = new List[this.borderNodes.size()][this.borderNodes.size()];
        for (int startIndex = 0; startIndex < this.borderNodes.size(); ++startIndex) {
            for (int targetIndex = 0; targetIndex < this.borderNodes.size(); ++targetIndex) {
                List<Segment> sequence;
                sequenceArray[startIndex][targetIndex] = sequence = this.findSegmentSequence(this.borderNodes.get(startIndex), this.borderNodes.get(targetIndex), restrictions);
            }
        }
        this.segmentSequences = sequenceArray;
    }

    @Override
    protected boolean isUsableNode(SegmentNode node) {
        return ConnectorEvaluationGroup.shareElement(this.segments, node.getInboundSegments()) || ConnectorEvaluationGroup.shareElement(this.segments, node.getOutboundSegments());
    }

    @Override
    protected boolean isUsableSegment(Segment segment) {
        return this.segments.contains(segment);
    }

    public String toString() {
        return "ConnectorEG " + this.segments;
    }
}

