/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.imagery_offset_db;

import java.util.Arrays;
import java.util.TreeMap;
import java.util.TreeSet;
import org.openstreetmap.josm.data.imagery.ImageryInfo;

public final class ImageryIdGenerator {
    private ImageryIdGenerator() {
    }

    public static String getImageryID(String url, ImageryInfo.ImageryType type) {
        String[] qparamsStr;
        if (url == null) {
            return null;
        }
        if (ImageryInfo.ImageryType.BING.equals((Object)type) || url.contains("tiles.virtualearth.net")) {
            return "bing";
        }
        if (ImageryInfo.ImageryType.SCANEX.equals((Object)type) && url.toLowerCase().equals("irs")) {
            return "scanex_irs";
        }
        if (ImageryInfo.ImageryType.TMS.equals((Object)type) && url.toLowerCase().matches(".+tiles\\.mapbox\\.com/v[3-9]/openstreetmap\\.map.*")) {
            return "mapbox";
        }
        boolean isWMS = ImageryInfo.ImageryType.WMS.equals((Object)type);
        int i = url.indexOf("://");
        if (i > 0) {
            url = url.substring(i + 3);
        }
        i = url.indexOf(63);
        String query = "";
        if (i > 0) {
            query = url.substring(i);
            url = url.substring(0, i);
        }
        TreeSet<String> removeWMSParams = new TreeSet<String>(Arrays.asList("srs", "width", "height", "bbox", "service", "request", "version", "format", "styles", "transparent"));
        TreeMap<String, String> qparams = new TreeMap<String, String>();
        for (String param : qparamsStr = query.length() > 1 ? query.substring(1).split("&") : new String[]{}) {
            String[] kv = param.split("=");
            kv[0] = kv[0].toLowerCase();
            if (isWMS && removeWMSParams.contains(kv[0]) || kv.length > 1 && kv[1].indexOf(123) >= 0 && kv[1].indexOf(125) > 0 || kv[0].equals("access_token")) continue;
            qparams.put(kv[0].toLowerCase(), kv.length > 1 ? kv[1] : null);
        }
        StringBuilder sb = new StringBuilder();
        for (String qk : qparams.keySet()) {
            if (sb.length() > 0) {
                sb.append('&');
            } else if (query.length() > 0) {
                sb.append('?');
            }
            sb.append(qk).append('=').append((String)qparams.get(qk));
        }
        query = sb.toString();
        url = url.replaceAll("\\/\\{[^}]+\\}(?:\\.\\w+)?", "");
        url = url.replaceAll("\\{[^}]+\\}", "");
        while (url.contains("..")) {
            url = url.replace("..", ".");
        }
        if (url.startsWith(".")) {
            url = url.substring(1);
        }
        return url + query;
    }
}

