/*
 * Decompiled with CFR 0.152.
 */
package ext_tools.preferences;

import ext_tools.ExtTool;
import ext_tools.ToolsInformation;
import ext_tools.preferences.EditToolDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.tools.I18n;

public class ToolsRepositoryPanel
extends JPanel {
    private final transient ToolsInformation tools;

    public ToolsRepositoryPanel(ToolsInformation tools) {
        super(new GridBagLayout());
        this.tools = tools;
    }

    public void refresh() {
        this.removeAll();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 5, 2, 5);
        for (final ExtTool tool : this.tools.getToolsList()) {
            gbc.gridx = 0;
            gbc.weightx = 1.0;
            gbc.anchor = 17;
            JCheckBox cbTool = new JCheckBox(tool.getName());
            cbTool.setSelected(tool.isEnabled());
            cbTool.addActionListener(e -> tool.setEnabled(cbTool.isSelected()));
            this.add((Component)cbTool, gbc);
            gbc.gridx = 1;
            gbc.weightx = 0.0;
            gbc.anchor = 13;
            JButton bEdit = new JButton(I18n.tr((String)"Install", (Object[])new Object[0]));
            bEdit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    EditToolDialog dlg = new EditToolDialog(tool);
                    ((Dialog)((Object)dlg)).setVisible(true);
                    ((Window)((Object)dlg)).dispose();
                    ToolsRepositoryPanel.this.refresh();
                }
            });
            this.add((Component)bEdit, gbc);
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.weightx = 1.0;
            gbc.anchor = 17;
            JLabel lbl = new JLabel(tool.cmdline);
            this.add((Component)lbl, gbc);
            ++gbc.gridy;
        }
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add((Component)new JPanel(), gbc);
        this.revalidate();
        this.repaint();
    }
}

