/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.surveyor.action;

import java.io.BufferedInputStream;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.plugins.surveyor.GpsActionEvent;
import org.openstreetmap.josm.plugins.surveyor.action.AbstractSurveyorAction;
import org.openstreetmap.josm.tools.Logging;

public class PlayAudioAction
extends AbstractSurveyorAction {
    private String audioSource = null;

    @Override
    public void actionPerformed(GpsActionEvent event) {
        MainApplication.worker.execute(() -> {
            if (this.audioSource == null) {
                this.audioSource = this.getParameters().get(0);
            }
            try (CachedFile cf = new CachedFile(this.audioSource);){
                AudioInputStream stream = AudioSystem.getAudioInputStream(new BufferedInputStream(cf.getInputStream()));
                AudioFormat format = stream.getFormat();
                if (format.getEncoding() != AudioFormat.Encoding.PCM_SIGNED) {
                    format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, format.getSampleRate(), format.getSampleSizeInBits() * 2, format.getChannels(), format.getFrameSize() * 2, format.getFrameRate(), true);
                    stream = AudioSystem.getAudioInputStream(format, stream);
                }
                DataLine.Info info = new DataLine.Info(Clip.class, stream.getFormat(), (int)stream.getFrameLength() * format.getFrameSize());
                Clip clip = (Clip)AudioSystem.getLine(info);
                clip.open(stream);
                clip.start();
            }
            catch (IOException | LineUnavailableException | UnsupportedAudioFileException e1) {
                Logging.error((Throwable)e1);
            }
        });
    }
}

