/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fr.cadastre.wms;

import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmDataManager;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.projection.ProjectionRegistry;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.plugins.fr.cadastre.CadastrePlugin;
import org.openstreetmap.josm.plugins.fr.cadastre.wms.CadastreInterface;
import org.openstreetmap.josm.plugins.fr.cadastre.wms.DuplicateLayerException;
import org.openstreetmap.josm.plugins.fr.cadastre.wms.EastNorthBound;
import org.openstreetmap.josm.plugins.fr.cadastre.wms.SVGParser;
import org.openstreetmap.josm.plugins.fr.cadastre.wms.WMSException;
import org.openstreetmap.josm.plugins.fr.cadastre.wms.WMSLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class DownloadSVGBuilding
extends PleaseWaitRunnable {
    private WMSLayer wmsLayer;
    private CadastreInterface wmsInterface;
    private String svg;
    private static EastNorthBound currentView;
    private EastNorthBound viewBox;
    private static String errorMessage;

    public DownloadSVGBuilding(WMSLayer wmsLayer) {
        super(I18n.tr((String)"Downloading {0}", (Object[])new Object[]{wmsLayer.getName()}));
        this.wmsLayer = wmsLayer;
        this.wmsInterface = wmsLayer.grabber.getWmsInterface();
    }

    public void realRun() throws IOException, OsmTransferException {
        this.progressMonitor.indeterminateSubTask(I18n.tr((String)"Contacting WMS Server...", (Object[])new Object[0]));
        errorMessage = null;
        try {
            if (this.wmsInterface.retrieveInterface(this.wmsLayer)) {
                this.svg = this.grabBoundary(currentView);
                if (this.svg == null) {
                    return;
                }
                this.getViewBox(this.svg);
                if (this.viewBox == null) {
                    return;
                }
                this.createBuildings(this.svg);
            }
        }
        catch (DuplicateLayerException e) {
            Logging.warn((String)"removed a duplicated layer");
        }
        catch (WMSException e) {
            errorMessage = e.getMessage();
            this.wmsLayer.grabber.getWmsInterface().resetCookie();
        }
    }

    protected void cancel() {
        this.wmsLayer.grabber.getWmsInterface().cancel();
    }

    protected void finish() {
    }

    private boolean getViewBox(String svg) {
        double[] box = new SVGParser().getViewBox(svg);
        if (box != null) {
            this.viewBox = new EastNorthBound(new EastNorth(box[0], box[1]), new EastNorth(box[0] + box[2], box[1] + box[3]));
            return true;
        }
        Logging.warn((String)"Unable to parse SVG data (viewBox)");
        return false;
    }

    private void createBuildings(String svg) {
        String[] SVGpaths = new SVGParser().getClosedPaths(svg);
        ArrayList eastNorths = new ArrayList();
        for (int i = 0; i < SVGpaths.length; ++i) {
            Iterator eastNorth = new ArrayList();
            this.createNodes(SVGpaths[i], (ArrayList<EastNorth>)((Object)eastNorth));
            if (((ArrayList)((Object)eastNorth)).size() <= 2) continue;
            eastNorths.add(eastNorth);
        }
        DataSet svgDataSet = new DataSet();
        for (ArrayList arrayList : eastNorths) {
            Way wayToAdd = new Way();
            for (EastNorth eastNorth : arrayList) {
                Node nearestNewNode;
                Node nodeToAdd = new Node(ProjectionRegistry.getProjection().eastNorth2latlon(eastNorth));
                if (nodeToAdd.equals((Object)(nearestNewNode = DownloadSVGBuilding.checkNearestNode(nodeToAdd, svgDataSet.getNodes())))) {
                    svgDataSet.addPrimitive((OsmPrimitive)nearestNewNode);
                }
                wayToAdd.addNode(nearestNewNode);
            }
            wayToAdd.addNode(wayToAdd.getNode(0));
            svgDataSet.addPrimitive((OsmPrimitive)wayToAdd);
        }
        for (Node node : svgDataSet.getNodes()) {
            Node nearestNewNode = DownloadSVGBuilding.checkNearestNode(node, MainApplication.getLayerManager().getEditDataSet().getNodes());
            if (nearestNewNode == node) continue;
            for (Way w : svgDataSet.getWays()) {
                int replaced = 0;
                for (Node node2 : w.getNodes()) {
                    if (node2 != node) continue;
                    node2 = nearestNewNode;
                    ++replaced;
                }
                if (w.getNodesCount() != replaced) continue;
                w.setDeleted(true);
            }
            node.setDeleted(true);
        }
        DataSet ds = OsmDataManager.getInstance().getEditDataSet();
        LinkedList<AddCommand> linkedList = new LinkedList<AddCommand>();
        for (Node node : svgDataSet.getNodes()) {
            if (node.isDeleted()) continue;
            linkedList.add(new AddCommand(ds, (OsmPrimitive)node));
        }
        for (Way way : svgDataSet.getWays()) {
            if (way.isDeleted()) continue;
            linkedList.add(new AddCommand(ds, (OsmPrimitive)way));
        }
        UndoRedoHandler.getInstance().add((Command)new SequenceCommand(I18n.tr((String)"Create buildings", (Object[])new Object[0]), linkedList));
        MainApplication.getMap().repaint();
    }

    private void createNodes(String SVGpath, ArrayList<EastNorth> eastNorth) {
        String[] coor = SVGpath.split("[MlZ ]");
        double dx = Double.parseDouble(coor[1]);
        double dy = Double.parseDouble(coor[2]);
        for (int i = 3; i < coor.length; i += 2) {
            if (coor[i].isEmpty()) {
                eastNorth.clear();
                return;
            }
            double east = dx += Double.parseDouble(coor[i]);
            double north = dy += Double.parseDouble(coor[i + 1]);
            eastNorth.add(new EastNorth(east, north));
        }
        double pivot = this.viewBox.min.getY() + (this.viewBox.max.getY() - this.viewBox.min.getY()) / 2.0;
        for (int i = 0; i < eastNorth.size(); ++i) {
            EastNorth en = eastNorth.get(i);
            eastNorth.set(i, new EastNorth(en.east(), 2.0 * pivot - en.north()));
        }
    }

    private static Node checkNearestNode(Node nodeToAdd, Collection<Node> nodes) {
        double epsilon = 0.05;
        for (Node n : nodes) {
            double dist;
            if (n.isDeleted() || n.isIncomplete() || !((dist = n.getEastNorth().distance(nodeToAdd.getEastNorth())) < epsilon)) continue;
            return n;
        }
        return nodeToAdd;
    }

    private String grabBoundary(EastNorthBound bbox) throws IOException, OsmTransferException {
        try {
            URL url = null;
            url = DownloadSVGBuilding.getURLsvg(bbox);
            return this.grabSVG(url);
        }
        catch (MalformedURLException e) {
            throw (IOException)new IOException(I18n.tr((String)"CadastreGrabber: Illegal url.", (Object[])new Object[0])).initCause(e);
        }
    }

    private static URL getURLsvg(EastNorthBound bbox) throws MalformedURLException {
        String str = "https://www.cadastre.gouv.fr/scpc/wms?version=1.1&request=GetMap";
        str = str + "&layers=";
        str = str + "CDIF:LS2";
        str = str + "&format=image/svg";
        str = str + "&bbox=" + bbox.min.east() + ",";
        str = str + bbox.min.north() + ",";
        str = str + bbox.max.east() + ",";
        str = str + bbox.max.north();
        str = str + "&width=" + CadastrePlugin.imageWidth + "&height=" + CadastrePlugin.imageHeight;
        str = str + "&exception=application/vnd.ogc.se_inimage";
        str = str + "&styles=";
        str = str + "LS2_90";
        Logging.info((String)("URL=" + str));
        return new URL(str.replace(" ", "%20"));
    }

    private String grabSVG(URL url) throws IOException, OsmTransferException {
        File file = new File(CadastrePlugin.cacheDir + "building.svg");
        String svg = "";
        try (InputStream is = this.wmsInterface.getContent(url);){
            if (file.exists()) {
                file.delete();
            }
            try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file, true));
                 InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
                 BufferedReader br = new BufferedReader(isr);){
                String line;
                while (null != (line = br.readLine())) {
                    line = line + "\n";
                    bos.write(line.getBytes(StandardCharsets.UTF_8));
                    svg = svg + line;
                }
            }
        }
        catch (IOException e) {
            Logging.error((Throwable)e);
        }
        return svg;
    }

    public static void download(WMSLayer wmsLayer) {
        MapView mv = MainApplication.getMap().mapView;
        currentView = new EastNorthBound(mv.getEastNorth(0, mv.getHeight()), mv.getEastNorth(mv.getWidth(), 0));
        if (DownloadSVGBuilding.currentView.max.east() - DownloadSVGBuilding.currentView.min.east() > 1000.0 || DownloadSVGBuilding.currentView.max.north() - DownloadSVGBuilding.currentView.min.north() > 1000.0) {
            JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"To avoid cadastre WMS overload,\nbuilding import size is limited to 1 km2 max.", (Object[])new Object[0]));
            return;
        }
        if (!CadastrePlugin.autoSourcing) {
            JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Please, enable auto-sourcing and check cadastre millesime.", (Object[])new Object[0]));
            return;
        }
        MainApplication.worker.execute((Runnable)((Object)new DownloadSVGBuilding(wmsLayer)));
        if (errorMessage != null) {
            JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), errorMessage);
        }
    }
}

