/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pdfimport;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openstreetmap.josm.plugins.pdfimport.GuiFieldBool;
import org.openstreetmap.josm.plugins.pdfimport.GuiFieldDouble;
import org.openstreetmap.josm.plugins.pdfimport.GuiFieldHex;
import org.openstreetmap.josm.plugins.pdfimport.GuiFieldInteger;
import org.openstreetmap.josm.plugins.pdfimport.Preferences;
import org.openstreetmap.josm.tools.I18n;

public class PathOptimizerConfig {
    public GuiFieldBool debugModeCheck;
    public GuiFieldBool mergeCloseNodesCheck;
    public GuiFieldDouble mergeCloseNodesTolerance;
    public GuiFieldBool removeSmallObjectsCheck;
    public GuiFieldDouble removeSmallObjectsSize;
    public JTextField colorFilterColor;
    public GuiFieldBool colorFilterCheck;
    public GuiFieldBool removeParallelSegmentsCheck;
    public GuiFieldDouble removeParallelSegmentsTolerance;
    public GuiFieldBool removeLargeObjectsCheck;
    public GuiFieldDouble removeLargeObjectsSize;
    public GuiFieldBool limitPathCountCheck;
    public GuiFieldInteger limitPathCount;
    public GuiFieldBool splitOnColorChangeCheck;
    public GuiFieldBool splitOnShapeClosedCheck;
    public GuiFieldBool splitOnSingleSegmentCheck;
    public GuiFieldBool splitOnOrthogonalCheck;
    protected JPanel panel;

    public PathOptimizerConfig() {
        this.build();
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public boolean save() {
        Preferences.setDebugTags(this.debugModeCheck.getValue());
        Preferences.setMergeNodesValue(this.mergeCloseNodesTolerance.getValue());
        Preferences.setMergeNodes(this.mergeCloseNodesCheck.getValue());
        Preferences.setRemoveSmallValue(this.removeSmallObjectsSize.getValue());
        Preferences.setRemoveSmall(this.removeSmallObjectsCheck.getValue());
        Preferences.setRemoveLargeValue(this.removeLargeObjectsSize.getValue());
        Preferences.setRemoveLarge(this.removeLargeObjectsCheck.getValue());
        Preferences.setLimitColorValue(this.colorFilterColor.getText());
        Preferences.setLimitColor(this.colorFilterCheck.getValue());
        Preferences.setRemoveParallelValue(this.removeParallelSegmentsTolerance.getValue());
        Preferences.setRemoveParallel(this.removeParallelSegmentsCheck.getValue());
        Preferences.setLimitPathValue(this.limitPathCount.getValue());
        Preferences.setLimitPath(this.limitPathCountCheck.getValue());
        Preferences.setLayerAttribChange(this.splitOnColorChangeCheck.getValue());
        Preferences.setLayerClosed(this.splitOnShapeClosedCheck.getValue());
        Preferences.setLayerSegment(this.splitOnSingleSegmentCheck.getValue());
        Preferences.setLayerOrtho(this.splitOnOrthogonalCheck.getValue());
        return true;
    }

    private void build() {
        this.debugModeCheck = new GuiFieldBool(I18n.tr((String)"Debug info", (Object[])new Object[0]), Preferences.isDebugTags());
        this.mergeCloseNodesTolerance = new GuiFieldDouble(Preferences.getMergeNodesValue());
        this.mergeCloseNodesCheck = new GuiFieldBool(I18n.tr((String)"Merge close nodes", (Object[])new Object[0]), Preferences.isMergeNodes());
        this.mergeCloseNodesCheck.setCompanion(this.mergeCloseNodesTolerance);
        this.removeSmallObjectsSize = new GuiFieldDouble(Preferences.getRemoveSmallValue());
        this.removeSmallObjectsCheck = new GuiFieldBool(I18n.tr((String)"Remove objects smaller than", (Object[])new Object[0]), Preferences.isRemoveSmall());
        this.removeSmallObjectsCheck.setCompanion(this.removeSmallObjectsSize);
        this.removeLargeObjectsSize = new GuiFieldDouble(Preferences.getRemoveLargeValue());
        this.removeLargeObjectsCheck = new GuiFieldBool(I18n.tr((String)"Remove objects larger than", (Object[])new Object[0]), Preferences.isRemoveLarge());
        this.removeLargeObjectsCheck.setCompanion(this.removeLargeObjectsSize);
        this.colorFilterColor = new GuiFieldHex(Preferences.getLimitColorValue());
        this.colorFilterCheck = new GuiFieldBool(I18n.tr((String)"Only this color", (Object[])new Object[0]), Preferences.isLimitColor());
        this.colorFilterCheck.setCompanion(this.colorFilterColor);
        this.removeParallelSegmentsTolerance = new GuiFieldDouble(Preferences.getRemoveParallelValue());
        this.removeParallelSegmentsCheck = new GuiFieldBool(I18n.tr((String)"Remove parallel lines", (Object[])new Object[0]), Preferences.isRemoveParallel());
        this.removeParallelSegmentsCheck.setCompanion(this.removeParallelSegmentsTolerance);
        this.limitPathCount = new GuiFieldInteger(Preferences.getLimitPathValue());
        this.limitPathCountCheck = new GuiFieldBool(I18n.tr((String)"Take only first X paths", (Object[])new Object[0]), Preferences.isLimitPath());
        this.limitPathCountCheck.setCompanion(this.limitPathCount);
        this.splitOnColorChangeCheck = new GuiFieldBool(I18n.tr((String)"Color/width change", (Object[])new Object[0]), Preferences.isLayerAttribChange());
        this.splitOnShapeClosedCheck = new GuiFieldBool(I18n.tr((String)"Shape closed", (Object[])new Object[0]), Preferences.isLayerClosed());
        this.splitOnSingleSegmentCheck = new GuiFieldBool(I18n.tr((String)"Single segments", (Object[])new Object[0]), Preferences.isLayerSegment());
        this.splitOnOrthogonalCheck = new GuiFieldBool(I18n.tr((String)"Orthogonal shapes", (Object[])new Object[0]), Preferences.isLayerOrtho());
        this.panel = new JPanel(new GridBagLayout());
        this.panel.setBorder(BorderFactory.createTitledBorder(I18n.tr((String)"Import settings", (Object[])new Object[0])));
        GridBagConstraints cBasic = new GridBagConstraints();
        cBasic.gridx = -1;
        cBasic.gridy = -1;
        cBasic.insets = new Insets(0, 0, 0, 4);
        cBasic.anchor = 21;
        cBasic.fill = 2;
        cBasic.gridheight = 1;
        cBasic.gridwidth = 1;
        cBasic.ipadx = 0;
        cBasic.ipady = 0;
        cBasic.weightx = 0.0;
        cBasic.weighty = 0.0;
        GridBagConstraints cLeft = (GridBagConstraints)cBasic.clone();
        cLeft.gridx = 0;
        GridBagConstraints cMiddle = (GridBagConstraints)cBasic.clone();
        cMiddle.gridx = 1;
        cMiddle.anchor = 22;
        GridBagConstraints cRight = (GridBagConstraints)cBasic.clone();
        cRight.gridx = 2;
        this.panel.add((Component)this.mergeCloseNodesCheck, cLeft);
        this.panel.add((Component)new JLabel(I18n.tr((String)"Tolerance:", (Object[])new Object[0]), 4), cMiddle);
        this.panel.add((Component)this.mergeCloseNodesTolerance, cRight);
        this.panel.add((Component)this.removeSmallObjectsCheck, cLeft);
        this.panel.add((Component)new JLabel(I18n.tr((String)"Tolerance:", (Object[])new Object[0]), 4), cMiddle);
        this.panel.add((Component)this.removeSmallObjectsSize, cRight);
        this.panel.add((Component)this.removeLargeObjectsCheck, cLeft);
        this.panel.add((Component)new JLabel(I18n.tr((String)"Tolerance:", (Object[])new Object[0]), 4), cMiddle);
        this.panel.add((Component)this.removeLargeObjectsSize, cRight);
        this.panel.add((Component)this.removeParallelSegmentsCheck, cLeft);
        this.panel.add((Component)new JLabel(I18n.tr((String)"Max distance:", (Object[])new Object[0]), 4), cMiddle);
        this.panel.add((Component)this.removeParallelSegmentsTolerance, cRight);
        this.panel.add((Component)this.limitPathCountCheck, cLeft);
        this.panel.add((Component)this.limitPathCount, cRight);
        this.panel.add((Component)this.colorFilterCheck, cLeft);
        this.panel.add((Component)this.colorFilterColor, cRight);
        this.panel.add((Component)this.debugModeCheck, cLeft);
        cLeft.gridy = 8;
        this.panel.add((Component)new JLabel(I18n.tr((String)"Introduce separate layers for:", (Object[])new Object[0])), cLeft);
        cMiddle.gridy = 8;
        this.panel.add((Component)this.splitOnShapeClosedCheck, cMiddle);
        cRight.gridy = 8;
        this.panel.add((Component)this.splitOnSingleSegmentCheck, cRight);
        cMiddle.gridy = 9;
        this.panel.add((Component)this.splitOnColorChangeCheck, cMiddle);
        cRight.gridy = 9;
        this.panel.add((Component)this.splitOnOrthogonalCheck, cRight);
    }
}

