/*
 * Decompiled with CFR 0.152.
 */
package tec.units.indriya.format;

import java.io.IOException;
import java.io.StringReader;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.format.ParserException;
import tec.units.indriya.AbstractUnit;
import tec.units.indriya.format.AbstractUnitFormat;
import tec.units.indriya.format.EBNFHelper;
import tec.units.indriya.format.SymbolMap;
import tec.units.indriya.internal.format.TokenException;
import tec.units.indriya.internal.format.TokenMgrError;
import tec.units.indriya.internal.format.UnitFormatParser;
import tec.units.indriya.unit.AnnotatedUnit;

public class EBNFUnitFormat
extends AbstractUnitFormat {
    private static final String BUNDLE_NAME = "tec.units.indriya.format.messages";
    private static final EBNFUnitFormat DEFAULT_INSTANCE = new EBNFUnitFormat();
    private final transient SymbolMap symbolMap;

    public static EBNFUnitFormat getInstance() {
        return DEFAULT_INSTANCE;
    }

    public static EBNFUnitFormat getInstance(SymbolMap symbols) {
        return new EBNFUnitFormat(symbols);
    }

    EBNFUnitFormat() {
        this(SymbolMap.of(ResourceBundle.getBundle(BUNDLE_NAME, Locale.ROOT)));
    }

    private EBNFUnitFormat(SymbolMap symbols) {
        this.symbolMap = symbols;
    }

    @Override
    protected SymbolMap getSymbols() {
        return this.symbolMap;
    }

    @Override
    public Appendable format(Unit<?> unit, Appendable appendable) throws IOException {
        AnnotatedUnit annotatedUnit;
        EBNFHelper.formatInternal(unit, appendable, this.symbolMap);
        if (unit instanceof AnnotatedUnit && (annotatedUnit = (AnnotatedUnit)unit).getAnnotation() != null) {
            appendable.append('{');
            appendable.append(annotatedUnit.getAnnotation());
            appendable.append('}');
        }
        return appendable;
    }

    @Override
    public boolean isLocaleSensitive() {
        return false;
    }

    protected Unit<? extends Quantity<?>> parse(CharSequence csq, ParsePosition cursor) throws ParserException {
        int start = cursor != null ? cursor.getIndex() : 0;
        int end = csq.length();
        if (end <= start) {
            return AbstractUnit.ONE;
        }
        String source = csq.subSequence(start, end).toString().trim();
        if (source.length() == 0) {
            return AbstractUnit.ONE;
        }
        try {
            UnitFormatParser parser = new UnitFormatParser(this.symbolMap, new StringReader(source));
            Unit<?> result = parser.parseUnit();
            if (cursor != null) {
                cursor.setIndex(end);
            }
            return result;
        }
        catch (TokenException e) {
            if (e.currentToken != null) {
                cursor.setErrorIndex(start + e.currentToken.endColumn);
            } else {
                cursor.setErrorIndex(start);
            }
            throw new ParserException(e);
        }
        catch (TokenMgrError e) {
            cursor.setErrorIndex(start);
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    protected Unit<?> parse(CharSequence csq, int index) throws IllegalArgumentException {
        return this.parse(csq, new ParsePosition(index));
    }

    @Override
    public Unit<?> parse(CharSequence csq) throws ParserException {
        return this.parse(csq, 0);
    }
}

