/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.common;

import javax.measure.Unit;
import javax.measure.quantity.Acceleration;
import javax.measure.quantity.Area;
import javax.measure.quantity.Force;
import javax.measure.quantity.Length;
import javax.measure.quantity.Mass;
import javax.measure.quantity.Temperature;
import javax.measure.quantity.Time;
import javax.measure.quantity.Volume;
import javax.measure.spi.SystemOfUnits;
import systems.uom.common.USCustomary;
import tec.uom.se.AbstractSystemOfUnits;
import tec.uom.se.AbstractUnit;
import tec.uom.se.format.SimpleUnitFormat;
import tec.uom.se.unit.MetricPrefix;
import tec.uom.se.unit.ProductUnit;
import tec.uom.se.unit.Units;

public final class Imperial
extends AbstractSystemOfUnits {
    static final int AVOIRDUPOIS_POUND_DIVIDEND = 45359237;
    static final int AVOIRDUPOIS_POUND_DIVISOR = 100000000;
    private static final int STANDARD_GRAVITY_DIVIDEND = 980665;
    private static final int STANDARD_GRAVITY_DIVISOR = 100000;
    private static final Imperial INSTANCE = new Imperial();
    public static final Unit<Length> INCH = Imperial.addUnit(USCustomary.INCH, "Inch", "in");
    static final Unit<Mass> POUND = Imperial.addUnit(Units.KILOGRAM.multiply(4.5359237E7).divide(1.0E8), "Pound", "lb", true);
    public static final Unit<Mass> STONE = Imperial.addUnit(Units.KILOGRAM.multiply(6.35029318), "st", true);
    public static final Unit<Mass> OUNCE = Imperial.addUnit(POUND.divide(16.0), "oz");
    public static final Unit<Mass> TON_UK = Imperial.addUnit(POUND.multiply(2240.0), "ton_uk");
    public static final Unit<Mass> METRIC_TON = Imperial.addUnit(Units.KILOGRAM.multiply(1000.0), "t");
    static final Unit<Temperature> RANKINE = Imperial.addUnit(Units.KELVIN.multiply(5.0).divide(9.0), "\u00b0R", true);
    static final Unit<Temperature> FAHRENHEIT = Imperial.addUnit(RANKINE.shift(459.67), "\u00b0F", true);
    static final Unit<Time> MINUTE = Imperial.addUnit(Units.SECOND.multiply(60.0));
    static final Unit<Time> HOUR = Imperial.addUnit(MINUTE.multiply(60.0));
    static final Unit<Acceleration> G = Imperial.addUnit(Units.METRE_PER_SQUARE_SECOND.multiply(980665.0).divide(100000.0));
    public static final Unit<Area> SQUARE_FOOT = Imperial.addUnit(USCustomary.SQUARE_FOOT, "sft", true);
    public static final Unit<Area> ACRE = Imperial.addUnit(USCustomary.SQUARE_FOOT.multiply(43560.0), "Acre", "ac", true);
    static final Unit<Volume> LITRE = Imperial.addUnit(Units.CUBIC_METRE.divide(1000.0), "L", true);
    static final Unit<Volume> CUBIC_INCH = Imperial.addUnit(new ProductUnit(USCustomary.INCH.pow(3)), "Cubic Inch", "in\u00b3");
    public static final Unit<Volume> GALLON_UK = Imperial.addUnit(LITRE.multiply(454609.0).divide(100000.0), "gal_uk");
    static final Unit<Volume> FLUID_OUNCE_UK = GALLON_UK.divide(160.0);
    public static final Unit<Volume> OUNCE_LIQUID = FLUID_OUNCE_UK;
    public static final Unit<Volume> FLUID_OUNCE = Imperial.addUnit(FLUID_OUNCE_UK, "fl_oz", true);
    public static final Unit<Volume> GILL = Imperial.addUnit(FLUID_OUNCE.multiply(5.0), "Gill", "gi");
    public static final Unit<Volume> PINT = Imperial.addUnit(FLUID_OUNCE.multiply(20.0), "Pint", "pt", true);
    public static final Unit<Volume> QUART = Imperial.addUnit(FLUID_OUNCE.multiply(40.0), "Quart", "qt");
    public static final Unit<Volume> MINIM = Imperial.addUnit(MetricPrefix.MICRO(LITRE).multiply(59.1938802), "Minim", "min_br");
    public static final Unit<Volume> FLUID_SCRUPLE = Imperial.addUnit(MINIM.multiply(60.0), "fl scr", true);
    public static final Unit<Volume> FLUID_DRACHM = Imperial.addUnit(FLUID_SCRUPLE.multiply(3.0), "fl drc", true);
    static final Unit<Force> POUND_FORCE = Imperial.addUnit(Units.NEWTON.multiply(4.4482216152605E13).divide(1.0E13));
    static final Unit<Force> KILOGRAM_FORCE = Imperial.addUnit(Units.NEWTON.multiply(980665.0).divide(100000.0));

    private Imperial() {
    }

    public static SystemOfUnits getInstance() {
        return INSTANCE;
    }

    private static <U extends Unit<?>> U addUnit(U unit) {
        Imperial.INSTANCE.units.add(unit);
        return unit;
    }

    private static <U extends Unit<?>> U addUnit(U unit, String name, String text, boolean isLabel) {
        if (isLabel) {
            SimpleUnitFormat.getInstance().label(unit, text);
        }
        if (name != null && unit instanceof AbstractUnit) {
            return AbstractSystemOfUnits.Helper.addUnit(Imperial.INSTANCE.units, unit, name);
        }
        Imperial.INSTANCE.units.add(unit);
        return unit;
    }

    private static <U extends Unit<?>> U addUnit(U unit, String name, String label) {
        return Imperial.addUnit(unit, name, label, true);
    }

    private static <U extends Unit<?>> U addUnit(U unit, String text, boolean isLabel) {
        return Imperial.addUnit(unit, null, text, isLabel);
    }

    private static <U extends Unit<?>> U addUnit(U unit, String text) {
        return Imperial.addUnit(unit, null, text, true);
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    static {
        SimpleUnitFormat.getInstance().label(FLUID_DRACHM, "fl drc");
        SimpleUnitFormat.getInstance().label(FLUID_SCRUPLE, "fl scr");
    }
}

