/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.media.jai.rangelookup;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import org.jaitools.media.jai.rangelookup.LookupItem;
import org.jaitools.media.jai.rangelookup.RangeLookupTable;
import org.jaitools.numeric.Range;

public class RangeLookupOpImage
extends PointOpImage {
    private final RangeLookupTable table;
    private final Number defaultValue;
    private final boolean hasDefault;

    public RangeLookupOpImage(RenderedImage source, Map config, ImageLayout layout, RangeLookupTable table, Number defaultValue) {
        super(source, layout, config, true);
        this.table = table;
        this.defaultValue = defaultValue;
        this.hasDefault = defaultValue != null;
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        Raster source = sources[0];
        Rectangle srcRect = this.mapDestRect(destRect, 0);
        RasterAccessor srcAcc = new RasterAccessor(source, srcRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor destAcc = new RasterAccessor(dest, destRect, formatTags[1], this.getColorModel());
        this.doLookup(srcAcc, destAcc);
    }

    private void doLookup(RasterAccessor srcAcc, RasterAccessor destAcc) {
        switch (destAcc.getDataType()) {
            case 0: {
                this.lookupAsByteData(srcAcc, destAcc);
                break;
            }
            case 3: {
                this.lookupAsIntData(srcAcc, destAcc);
                break;
            }
            case 2: {
                this.lookupAsShortData(srcAcc, destAcc);
                break;
            }
            case 1: {
                this.lookupAsUShortData(srcAcc, destAcc);
                break;
            }
            case 4: {
                this.lookupAsFloatData(srcAcc, destAcc);
                break;
            }
            case 5: {
                this.lookupAsDoubleData(srcAcc, destAcc);
            }
        }
        if (destAcc.isDataCopy()) {
            destAcc.clampDataArrays();
            destAcc.copyDataToRaster();
        }
    }

    private void lookupAsByteData(RasterAccessor srcAcc, RasterAccessor destAcc) {
        int typedDefaultValue;
        byte[][] srcData = srcAcc.getByteDataArrays();
        byte[][] destData = destAcc.getByteDataArrays();
        int destWidth = destAcc.getWidth();
        int destHeight = destAcc.getHeight();
        int destBands = destAcc.getNumBands();
        int[] dstBandOffsets = destAcc.getBandOffsets();
        int dstPixelStride = destAcc.getPixelStride();
        int dstScanlineStride = destAcc.getScanlineStride();
        int[] srcBandOffsets = srcAcc.getBandOffsets();
        int srcPixelStride = srcAcc.getPixelStride();
        int srcScanlineStride = srcAcc.getScanlineStride();
        Range<Byte> lastRange = null;
        int destinationValue = typedDefaultValue = this.hasDefault ? (int)this.defaultValue.byteValue() : -128;
        for (int k = 0; k < destBands; ++k) {
            int destY = destAcc.getY();
            byte[] destBandData = destData[k];
            byte[] srcBandData = srcData[k];
            int srcScanlineOffset = srcBandOffsets[k];
            int dstScanlineOffset = dstBandOffsets[k];
            int j = 0;
            while (j < destHeight) {
                int destX = destAcc.getX();
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                int i = 0;
                while (i < destWidth) {
                    byte val = (byte)(srcBandData[srcPixelOffset] & 0xFF);
                    if (lastRange == null || !lastRange.contains(val)) {
                        lastRange = null;
                        LookupItem item = this.table.getLookupItem(val);
                        if (item != null) {
                            lastRange = item.getRange();
                            destinationValue = ((Number)item.getValue()).byteValue();
                        } else {
                            destinationValue = this.hasDefault ? typedDefaultValue : (int)val;
                        }
                    }
                    destBandData[dstPixelOffset] = destinationValue;
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                    ++i;
                    ++destX;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
                ++j;
                ++destY;
            }
        }
    }

    private void lookupAsShortData(RasterAccessor srcAcc, RasterAccessor destAcc) {
        int typedDefaultValue;
        short[][] srcData = srcAcc.getShortDataArrays();
        short[][] destData = destAcc.getShortDataArrays();
        int destWidth = destAcc.getWidth();
        int destHeight = destAcc.getHeight();
        int destBands = destAcc.getNumBands();
        int[] dstBandOffsets = destAcc.getBandOffsets();
        int dstPixelStride = destAcc.getPixelStride();
        int dstScanlineStride = destAcc.getScanlineStride();
        int[] srcBandOffsets = srcAcc.getBandOffsets();
        int srcPixelStride = srcAcc.getPixelStride();
        int srcScanlineStride = srcAcc.getScanlineStride();
        Range<Short> lastRange = null;
        int destinationValue = typedDefaultValue = this.hasDefault ? (int)this.defaultValue.shortValue() : Short.MIN_VALUE;
        for (int k = 0; k < destBands; ++k) {
            int destY = destAcc.getY();
            short[] destBandData = destData[k];
            short[] srcBandData = srcData[k];
            int srcScanlineOffset = srcBandOffsets[k];
            int dstScanlineOffset = dstBandOffsets[k];
            int j = 0;
            while (j < destHeight) {
                int destX = destAcc.getX();
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                int i = 0;
                while (i < destWidth) {
                    int val = srcBandData[srcPixelOffset];
                    if (lastRange == null || !lastRange.contains((short)val)) {
                        lastRange = null;
                        LookupItem item = this.table.getLookupItem((short)val);
                        if (item != null) {
                            lastRange = item.getRange();
                            destinationValue = ((Number)item.getValue()).shortValue();
                        } else {
                            destinationValue = this.hasDefault ? typedDefaultValue : val;
                        }
                    }
                    destBandData[dstPixelOffset] = destinationValue;
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                    ++i;
                    ++destX;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
                ++j;
                ++destY;
            }
        }
    }

    private void lookupAsUShortData(RasterAccessor srcAcc, RasterAccessor destAcc) {
        short typedDefaultValue;
        short[][] srcData = srcAcc.getShortDataArrays();
        short[][] destData = destAcc.getShortDataArrays();
        int destWidth = destAcc.getWidth();
        int destHeight = destAcc.getHeight();
        int destBands = destAcc.getNumBands();
        int[] dstBandOffsets = destAcc.getBandOffsets();
        int dstPixelStride = destAcc.getPixelStride();
        int dstScanlineStride = destAcc.getScanlineStride();
        int[] srcBandOffsets = srcAcc.getBandOffsets();
        int srcPixelStride = srcAcc.getPixelStride();
        int srcScanlineStride = srcAcc.getScanlineStride();
        Range<Integer> lastRange = null;
        short destinationValue = typedDefaultValue = this.hasDefault ? this.defaultValue.shortValue() : (short)0;
        for (int k = 0; k < destBands; ++k) {
            int destY = destAcc.getY();
            short[] destBandData = destData[k];
            short[] srcBandData = srcData[k];
            int srcScanlineOffset = srcBandOffsets[k];
            int dstScanlineOffset = dstBandOffsets[k];
            int j = 0;
            while (j < destHeight) {
                int destX = destAcc.getX();
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                int i = 0;
                while (i < destWidth) {
                    int val = srcBandData[srcPixelOffset] & 0xFFFF;
                    if (lastRange == null || !lastRange.contains(val)) {
                        lastRange = null;
                        LookupItem item = this.table.getLookupItem(val);
                        if (item != null) {
                            lastRange = item.getRange();
                            destinationValue = ((Number)item.getValue()).shortValue();
                        } else {
                            destinationValue = this.hasDefault ? typedDefaultValue : (short)val;
                        }
                    }
                    destBandData[dstPixelOffset] = destinationValue;
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                    ++i;
                    ++destX;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
                ++j;
                ++destY;
            }
        }
    }

    private void lookupAsIntData(RasterAccessor srcAcc, RasterAccessor destAcc) {
        int typedDefaultValue;
        int[][] srcData = srcAcc.getIntDataArrays();
        int[][] destData = destAcc.getIntDataArrays();
        int destWidth = destAcc.getWidth();
        int destHeight = destAcc.getHeight();
        int destBands = destAcc.getNumBands();
        int[] dstBandOffsets = destAcc.getBandOffsets();
        int dstPixelStride = destAcc.getPixelStride();
        int dstScanlineStride = destAcc.getScanlineStride();
        int[] srcBandOffsets = srcAcc.getBandOffsets();
        int srcPixelStride = srcAcc.getPixelStride();
        int srcScanlineStride = srcAcc.getScanlineStride();
        Range<Integer> lastRange = null;
        int destinationValue = typedDefaultValue = this.hasDefault ? this.defaultValue.intValue() : Integer.MIN_VALUE;
        for (int k = 0; k < destBands; ++k) {
            int destY = destAcc.getY();
            int[] destBandData = destData[k];
            int[] srcBandData = srcData[k];
            int srcScanlineOffset = srcBandOffsets[k];
            int dstScanlineOffset = dstBandOffsets[k];
            int j = 0;
            while (j < destHeight) {
                int destX = destAcc.getX();
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                int i = 0;
                while (i < destWidth) {
                    int val = srcBandData[srcPixelOffset];
                    if (lastRange == null || !lastRange.contains(val)) {
                        lastRange = null;
                        LookupItem item = this.table.getLookupItem(val);
                        if (item != null) {
                            lastRange = item.getRange();
                            destinationValue = ((Number)item.getValue()).intValue();
                        } else {
                            destinationValue = this.hasDefault ? typedDefaultValue : val;
                        }
                    }
                    destBandData[dstPixelOffset] = destinationValue;
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                    ++i;
                    ++destX;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
                ++j;
                ++destY;
            }
        }
    }

    private void lookupAsFloatData(RasterAccessor srcAcc, RasterAccessor destAcc) {
        float typedDefaultValue;
        float[][] srcData = srcAcc.getFloatDataArrays();
        float[][] destData = destAcc.getFloatDataArrays();
        int destWidth = destAcc.getWidth();
        int destHeight = destAcc.getHeight();
        int destBands = destAcc.getNumBands();
        int[] dstBandOffsets = destAcc.getBandOffsets();
        int dstPixelStride = destAcc.getPixelStride();
        int dstScanlineStride = destAcc.getScanlineStride();
        int[] srcBandOffsets = srcAcc.getBandOffsets();
        int srcPixelStride = srcAcc.getPixelStride();
        int srcScanlineStride = srcAcc.getScanlineStride();
        Range<Float> lastRange = null;
        float destinationValue = typedDefaultValue = this.hasDefault ? this.defaultValue.floatValue() : Float.NaN;
        for (int k = 0; k < destBands; ++k) {
            int destY = destAcc.getY();
            float[] destBandData = destData[k];
            float[] srcBandData = srcData[k];
            int srcScanlineOffset = srcBandOffsets[k];
            int dstScanlineOffset = dstBandOffsets[k];
            int j = 0;
            while (j < destHeight) {
                int destX = destAcc.getX();
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                int i = 0;
                while (i < destWidth) {
                    float val = srcBandData[srcPixelOffset];
                    if (lastRange == null || !lastRange.contains(Float.valueOf(val))) {
                        lastRange = null;
                        LookupItem item = this.table.getLookupItem(Float.valueOf(val));
                        if (item != null) {
                            lastRange = item.getRange();
                            destinationValue = ((Number)item.getValue()).floatValue();
                        } else {
                            destinationValue = this.hasDefault ? typedDefaultValue : val;
                        }
                    }
                    destBandData[dstPixelOffset] = destinationValue;
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                    ++i;
                    ++destX;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
                ++j;
                ++destY;
            }
        }
    }

    private void lookupAsDoubleData(RasterAccessor srcAcc, RasterAccessor destAcc) {
        double typedDefaultValue;
        double[][] srcData = srcAcc.getDoubleDataArrays();
        double[][] destData = destAcc.getDoubleDataArrays();
        int destWidth = destAcc.getWidth();
        int destHeight = destAcc.getHeight();
        int destBands = destAcc.getNumBands();
        int[] dstBandOffsets = destAcc.getBandOffsets();
        int dstPixelStride = destAcc.getPixelStride();
        int dstScanlineStride = destAcc.getScanlineStride();
        int[] srcBandOffsets = srcAcc.getBandOffsets();
        int srcPixelStride = srcAcc.getPixelStride();
        int srcScanlineStride = srcAcc.getScanlineStride();
        Range<Double> lastRange = null;
        double destinationValue = typedDefaultValue = this.hasDefault ? this.defaultValue.doubleValue() : Double.NaN;
        for (int k = 0; k < destBands; ++k) {
            int destY = destAcc.getY();
            double[] destBandData = destData[k];
            double[] srcBandData = srcData[k];
            int srcScanlineOffset = srcBandOffsets[k];
            int dstScanlineOffset = dstBandOffsets[k];
            int j = 0;
            while (j < destHeight) {
                int destX = destAcc.getX();
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                int i = 0;
                while (i < destWidth) {
                    double val = srcBandData[srcPixelOffset];
                    if (lastRange == null || !lastRange.contains(val)) {
                        lastRange = null;
                        LookupItem item = this.table.getLookupItem(val);
                        if (item != null) {
                            lastRange = item.getRange();
                            destinationValue = ((Number)item.getValue()).doubleValue();
                        } else {
                            destinationValue = this.hasDefault ? typedDefaultValue : val;
                        }
                    }
                    destBandData[dstPixelOffset] = destinationValue;
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                    ++i;
                    ++destX;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
                ++j;
                ++destY;
            }
        }
    }
}

