/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.geotools.util.CheckedCollection;
import org.geotools.util.SuppressFBWarnings;
import org.geotools.util.WeakCollectionCleaner;
import org.geotools.util.XArray;
import org.geotools.util.logging.Logging;

public class WeakHashSet<E>
extends AbstractSet<E>
implements CheckedCollection<E> {
    private static final int MIN_CAPACITY = 7;
    private static final float LOAD_FACTOR = 0.75f;
    private Entry[] table;
    private final Class<E> type;
    private int count;
    private int threshold;
    private long lastRehashTime;
    private static final long HOLD_TIME = 20000L;
    static final int REMOVE = -1;
    static final int GET = 0;
    static final int ADD = 1;
    static final int INTERN = 2;

    public WeakHashSet(Class<E> type) {
        this.type = type;
        this.newEntryTable(7);
        this.threshold = Math.round((float)this.table.length * 0.75f);
        this.lastRehashTime = System.currentTimeMillis();
    }

    private void newEntryTable(int size) {
        this.table = (Entry[])Array.newInstance(Entry.class, size);
    }

    @Override
    public Class<E> getElementType() {
        return this.type;
    }

    private synchronized void removeEntry(Entry toRemove) {
        assert (this.valid()) : this.count;
        int i = toRemove.index;
        if (i < this.table.length) {
            Entry prev = null;
            Entry e = this.table[i];
            while (e != null) {
                if (e == toRemove) {
                    if (prev != null) {
                        prev.next = e.next;
                    } else {
                        this.table[i] = e.next;
                    }
                    --this.count;
                    assert (this.valid());
                    if (this.count <= this.threshold / 4) {
                        this.rehash(false);
                    }
                    return;
                }
                prev = e;
                e = e.next;
            }
        }
        assert (this.valid());
    }

    private void rehash(boolean augmentation) {
        Level level;
        assert (Thread.holdsLock(this));
        assert (this.valid());
        long currentTime = System.currentTimeMillis();
        int capacity = Math.max(Math.round((float)this.count / 0.375f), this.count + 7);
        if (augmentation ? capacity <= this.table.length : capacity >= this.table.length || currentTime - this.lastRehashTime < 20000L) {
            return;
        }
        this.lastRehashTime = currentTime;
        Entry[] oldTable = this.table;
        this.newEntryTable(capacity);
        this.threshold = Math.round((float)capacity * 0.75f);
        for (int i = 0; i < oldTable.length; ++i) {
            Entry old = oldTable[i];
            while (old != null) {
                Entry e = old;
                old = old.next;
                Object obj_e = e.get();
                if (obj_e != null) {
                    int index;
                    e.index = index = (obj_e.hashCode() & Integer.MAX_VALUE) % this.table.length;
                    e.next = this.table[index];
                    this.table[index] = e;
                    continue;
                }
                --this.count;
            }
        }
        Logger logger = Logging.getLogger(WeakHashSet.class);
        if (logger.isLoggable(level = Level.FINEST)) {
            LogRecord record = new LogRecord(level, "Rehash from " + oldTable.length + " to " + this.table.length);
            record.setSourceMethodName(augmentation ? "unique" : "remove");
            record.setSourceClassName(WeakHashSet.class.getName());
            record.setLoggerName(logger.getName());
            logger.log(record);
        }
        assert (this.valid());
    }

    private boolean valid() {
        int n = 0;
        for (int i = 0; i < this.table.length; ++i) {
            Entry e = this.table[i];
            while (e != null) {
                ++n;
                e = e.next;
            }
        }
        if (n != this.count) {
            this.count = n;
            return false;
        }
        return true;
    }

    @Override
    public synchronized int size() {
        assert (this.valid());
        return this.count;
    }

    @Override
    public synchronized boolean contains(Object obj) {
        return obj != null && this.intern(this.type.cast(obj), 0) != null;
    }

    @Override
    public synchronized boolean remove(Object obj) {
        return this.intern(this.type.cast(obj), -1) != null;
    }

    @Override
    public synchronized boolean add(E obj) {
        return this.intern(obj, 1) == null;
    }

    @SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
    final <T extends E> T intern(T obj, int operation) {
        assert (Thread.holdsLock(this));
        assert (WeakCollectionCleaner.DEFAULT.isAlive());
        assert (this.valid()) : this.count;
        if (obj != null) {
            assert (obj.equals(obj)) : obj;
            int hash = obj.hashCode() & Integer.MAX_VALUE;
            int index = hash % this.table.length;
            Entry e = this.table[index];
            while (e != null) {
                Object candidate = e.get();
                if (candidate != null && candidate.equals(obj)) {
                    if (operation == -1) {
                        e.clear();
                    }
                    assert (candidate.getClass().equals(obj.getClass())) : candidate;
                    Object result = candidate;
                    return result;
                }
                e = e.next;
            }
            if (operation >= 1) {
                if (this.count >= this.threshold) {
                    this.rehash(true);
                    index = hash % this.table.length;
                }
                this.table[index] = new Entry(obj, this.table[index], index);
                ++this.count;
            }
        }
        assert (this.valid());
        return (T)(operation == 2 ? obj : null);
    }

    @Override
    public synchronized void clear() {
        Arrays.fill(this.table, null);
        this.count = 0;
    }

    @Override
    public synchronized E[] toArray() {
        assert (this.valid());
        Object[] elements = (Object[])Array.newInstance(this.type, this.count);
        int index = 0;
        for (int i = 0; i < this.table.length; ++i) {
            Entry el = this.table[i];
            while (el != null) {
                elements[index] = el.get();
                if (elements[index] != null) {
                    ++index;
                }
                el = el.next;
            }
        }
        return XArray.resize(elements, index);
    }

    @Override
    public Iterator<E> iterator() {
        return Arrays.asList(this.toArray()).iterator();
    }

    private final class Entry
    extends WeakReference<E> {
        Entry next;
        int index;

        Entry(E obj, Entry next, int index) {
            super(obj, WeakCollectionCleaner.DEFAULT.referenceQueue);
            this.next = next;
            this.index = index;
        }

        @Override
        public void clear() {
            super.clear();
            WeakHashSet.this.removeEntry(this);
        }
    }
}

