/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.cs;

import java.util.Map;
import org.geotools.measure.Measure;
import org.geotools.referencing.cs.AbstractCS;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.VerticalCS;

public class DefaultVerticalCS
extends AbstractCS
implements VerticalCS {
    private static final long serialVersionUID = 1201155778896630499L;
    public static DefaultVerticalCS GRAVITY_RELATED_HEIGHT = new DefaultVerticalCS(DefaultCoordinateSystemAxis.GRAVITY_RELATED_HEIGHT);
    public static DefaultVerticalCS ELLIPSOIDAL_HEIGHT = new DefaultVerticalCS(DefaultCoordinateSystemAxis.ELLIPSOIDAL_HEIGHT);
    public static DefaultVerticalCS DEPTH = new DefaultVerticalCS(DefaultCoordinateSystemAxis.DEPTH);

    public DefaultVerticalCS(VerticalCS cs) {
        super(cs);
    }

    public DefaultVerticalCS(CoordinateSystemAxis axis) {
        super(DefaultVerticalCS.getProperties(axis), new CoordinateSystemAxis[]{axis});
    }

    public DefaultVerticalCS(String name, CoordinateSystemAxis axis) {
        super(name, new CoordinateSystemAxis[]{axis});
    }

    public DefaultVerticalCS(Map<String, ?> properties, CoordinateSystemAxis axis) {
        super(properties, new CoordinateSystemAxis[]{axis});
    }

    @Override
    protected boolean isCompatibleDirection(AxisDirection direction) {
        return AxisDirection.UP.equals(direction.absolute());
    }

    @Override
    public Measure distance(double[] coord1, double[] coord2) throws MismatchedDimensionException {
        this.ensureDimensionMatch("coord1", coord1);
        this.ensureDimensionMatch("coord2", coord2);
        return new Measure(Math.abs(coord1[0] - coord2[0]), this.getDistanceUnit());
    }
}

