/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry;

import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.metadata.i18n.Errors;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.factory.FactoryRegistryException;
import org.geotools.util.factory.Hints;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class TransformedDirectPosition
extends GeneralDirectPosition {
    private static final long serialVersionUID = -3988283183934950437L;
    private final CoordinateOperationFactory factory;
    private final CoordinateReferenceSystem defaultCRS;
    private transient CoordinateReferenceSystem sourceCRS;
    private transient MathTransform forward;
    private transient MathTransform inverse;

    public TransformedDirectPosition() {
        this(null, DefaultGeographicCRS.WGS84, null);
    }

    public TransformedDirectPosition(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, Hints hints) throws FactoryRegistryException {
        super(targetCRS);
        TransformedDirectPosition.ensureNonNull("targetCRS", targetCRS);
        this.defaultCRS = CRS.equalsIgnoreMetadata(sourceCRS, targetCRS) ? null : sourceCRS;
        this.factory = ReferencingFactoryFinder.getCoordinateOperationFactory(hints);
    }

    @Override
    public void setCoordinateReferenceSystem(CoordinateReferenceSystem crs) throws MismatchedDimensionException {
        TransformedDirectPosition.ensureNonNull("crs", crs);
        super.setCoordinateReferenceSystem(crs);
        this.forward = null;
        this.inverse = null;
    }

    private void setSourceCRS(CoordinateReferenceSystem crs) throws TransformException {
        CoordinateOperation operation;
        CoordinateReferenceSystem targetCRS = this.getCoordinateReferenceSystem();
        try {
            operation = this.factory.createOperation(crs, targetCRS);
        }
        catch (FactoryException exception) {
            throw new TransformException(exception.getLocalizedMessage(), exception);
        }
        this.forward = operation.getMathTransform();
        this.inverse = null;
        this.sourceCRS = crs;
    }

    public void transform(DirectPosition position) throws TransformException {
        CoordinateReferenceSystem userCRS = position.getCoordinateReferenceSystem();
        if (userCRS == null && (userCRS = this.defaultCRS) == null) {
            this.setLocation(position);
            return;
        }
        if (this.forward == null || !CRS.equalsIgnoreMetadata(this.sourceCRS, userCRS)) {
            this.setSourceCRS(userCRS);
        }
        if (this.forward.transform(position, this) != this) {
            throw new AssertionError(this.forward);
        }
    }

    public DirectPosition inverseTransform(CoordinateReferenceSystem crs) throws TransformException {
        if (this.inverse == null || !CRS.equalsIgnoreMetadata(this.sourceCRS, crs)) {
            TransformedDirectPosition.ensureNonNull("crs", crs);
            this.setSourceCRS(crs);
            this.inverse = this.forward.inverse();
        }
        return this.inverse.transform(this, null);
    }

    public DirectPosition inverseTransform() throws TransformException {
        if (this.defaultCRS != null) {
            return this.inverseTransform(this.defaultCRS);
        }
        return new GeneralDirectPosition(this);
    }

    private static void ensureNonNull(String name, Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException(Errors.format(143, name));
        }
    }
}

