/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.type;

import java.util.Map;
import org.geotools.feature.type.PropertyDescriptorImpl;
import org.geotools.util.Classes;
import org.geotools.util.Utilities;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.Name;

public class AttributeDescriptorImpl
extends PropertyDescriptorImpl
implements AttributeDescriptor {
    protected final Object defaultValue;

    public AttributeDescriptorImpl(AttributeType type, Name name, int min, int max, boolean isNillable, Object defaultValue) {
        super(type, name, min, max, isNillable);
        this.defaultValue = defaultValue;
    }

    @Override
    public AttributeType getType() {
        return (AttributeType)super.getType();
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof AttributeDescriptorImpl)) {
            return false;
        }
        AttributeDescriptorImpl d = (AttributeDescriptorImpl)o;
        return super.equals(o) && Utilities.deepEquals(this.defaultValue, d.defaultValue);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(Classes.getShortClassName(this));
        sb.append(" ");
        sb.append(this.getName());
        if (this.type != null) {
            sb.append(" <");
            sb.append(this.type.getName().getLocalPart());
            sb.append(":");
            sb.append(Classes.getShortName(this.type.getBinding()));
            sb.append(">");
        }
        if (this.isNillable) {
            sb.append(" nillable");
        }
        if (this.minOccurs != 1 || this.maxOccurs != 1) {
            sb.append(" ");
            sb.append(this.minOccurs);
            sb.append(":");
            sb.append(this.maxOccurs);
        }
        if (this.defaultValue != null) {
            sb.append("\ndefault= ");
            sb.append(this.defaultValue);
        }
        if (this.userData != null && !this.userData.isEmpty()) {
            sb.append("\nuserData=(");
            for (Map.Entry entry : this.userData.entrySet()) {
                sb.append("\n\t");
                sb.append(entry.getKey());
                sb.append(" ==> ");
                sb.append(entry.getValue());
            }
            sb.append(")");
        }
        return sb.toString();
    }

    @Override
    public String getLocalName() {
        return this.getName().getLocalPart();
    }
}

