/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.util;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.factory.Hints;
import org.opengis.temporal.Instant;

public class TemporalConverterFactory
implements ConverterFactory {
    public Converter createConverter(Class source, Class target, Hints hints) {
        Object safe;
        boolean isSafeOnly = false;
        if (hints != null && (safe = hints.get(ConverterFactory.SAFE_CONVERSION)) instanceof Boolean && ((Boolean)safe).booleanValue()) {
            isSafeOnly = true;
        }
        if (Date.class.isAssignableFrom(source)) {
            if (Calendar.class.isAssignableFrom(target)) {
                if (isSafeOnly && Timestamp.class.isAssignableFrom(source)) {
                    return null;
                }
                return new Converter(){

                    public Object convert(Object source, Class target) throws Exception {
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime((Date)source);
                        return calendar;
                    }
                };
            }
            if (Timestamp.class.isAssignableFrom(target) || Time.class.isAssignableFrom(target) || java.sql.Date.class.isAssignableFrom(target)) {
                if (isSafeOnly && Time.class.isAssignableFrom(target)) {
                    return null;
                }
                return new Converter(){

                    public Object convert(Object source, Class target) throws Exception {
                        Date date = (Date)source;
                        return TemporalConverterFactory.this.timeMillisToDate(date.getTime(), target);
                    }
                };
            }
            if (XMLGregorianCalendar.class.isAssignableFrom(target)) {
                return new Converter(){

                    @Override
                    public <T> T convert(Object source, Class<T> target) throws Exception {
                        Date date = (Date)source;
                        Calendar calendar = TemporalConverterFactory.this.createConverter((Class)Date.class, (Class)Calendar.class, (Hints)null).convert(date, Calendar.class);
                        return (T)TemporalConverterFactory.this.createConverter((Class)Calendar.class, (Class)XMLGregorianCalendar.class, (Hints)null).convert(calendar, XMLGregorianCalendar.class);
                    }
                };
            }
            if (Long.class.equals((Object)target)) {
                return new Converter(){

                    @Override
                    public <T> T convert(Object source, Class<T> target) throws Exception {
                        return (T)Long.valueOf(((Date)source).getTime());
                    }
                };
            }
        }
        if (Calendar.class.isAssignableFrom(source)) {
            if (Date.class.isAssignableFrom(target)) {
                if (isSafeOnly && Time.class.isAssignableFrom(target)) {
                    return null;
                }
                return new Converter(){

                    public Object convert(Object source, Class target) throws Exception {
                        Calendar calendar = (Calendar)source;
                        return TemporalConverterFactory.this.timeMillisToDate(calendar.getTimeInMillis(), target, calendar.getTimeZone());
                    }
                };
            }
            if (XMLGregorianCalendar.class.isAssignableFrom(target)) {
                return new Converter(){

                    @Override
                    public <T> T convert(Object source, Class<T> target) throws Exception {
                        if (source instanceof GregorianCalendar) {
                            return (T)DatatypeFactory.newInstance().newXMLGregorianCalendar((GregorianCalendar)source);
                        }
                        return null;
                    }
                };
            }
        }
        if (XMLGregorianCalendar.class.isAssignableFrom(source)) {
            if (Calendar.class.isAssignableFrom(target)) {
                return new Converter(){

                    @Override
                    public <T> T convert(Object source, Class<T> target) throws Exception {
                        XMLGregorianCalendar calendar = (XMLGregorianCalendar)source;
                        return (T)calendar.toGregorianCalendar();
                    }
                };
            }
            if (Date.class.isAssignableFrom(target)) {
                return new Converter(){

                    @Override
                    public <T> T convert(Object source, Class<T> target) throws Exception {
                        Calendar calendar = TemporalConverterFactory.this.createConverter((Class)XMLGregorianCalendar.class, (Class)Calendar.class, (Hints)null).convert(source, Calendar.class);
                        if (calendar != null) {
                            return (T)TemporalConverterFactory.this.createConverter((Class)Calendar.class, (Class)Date.class, (Hints)null).convert(calendar, Date.class);
                        }
                        return null;
                    }
                };
            }
        }
        if (TimeZone.class.isAssignableFrom(source) && String.class == target) {
            return new Converter(){

                @Override
                public <T> T convert(Object source, Class<T> target) throws Exception {
                    if (source == null) {
                        return null;
                    }
                    return target.cast(((TimeZone)source).getID());
                }
            };
        }
        if (Instant.class.isAssignableFrom(source) && Date.class == target) {
            return new Converter(){

                @Override
                public <T> T convert(Object source, Class<T> target) throws Exception {
                    Instant instant = (Instant)source;
                    return (T)instant.getPosition().getDate();
                }
            };
        }
        if (Long.class.isAssignableFrom(source) && Date.class.isAssignableFrom(target)) {
            return new Converter(){

                public Object convert(Object source, Class target) throws Exception {
                    if (source != null) {
                        return new Date((Long)source);
                    }
                    return null;
                }
            };
        }
        return null;
    }

    Date timeMillisToDate(long time, Class target) {
        return this.timeMillisToDate(time, target, TimeZone.getDefault());
    }

    Date timeMillisToDate(long time, Class target, TimeZone zone) {
        if (Timestamp.class.isAssignableFrom(target)) {
            return new Timestamp(time);
        }
        if (java.sql.Date.class.isAssignableFrom(target)) {
            Calendar cal = Calendar.getInstance(zone);
            cal.setTimeInMillis(time);
            cal.set(10, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            return new java.sql.Date(cal.getTimeInMillis());
        }
        if (Time.class.isAssignableFrom(target)) {
            Calendar cal = Calendar.getInstance(zone);
            cal.setTimeInMillis(time);
            cal.set(1, 0);
            cal.set(2, 0);
            cal.set(5, 0);
            return new Time(cal.getTimeInMillis());
        }
        if (Date.class.isAssignableFrom(target)) {
            return new Date(time);
        }
        throw new IllegalArgumentException("Unsupported target type " + target);
    }
}

