/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid;

import it.geosolutions.jaiext.range.NoDataContainer;
import it.geosolutions.jaiext.range.Range;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import javax.media.jai.BorderExtender;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.ROI;
import javax.media.jai.iterator.RectIter;
import javax.media.jai.iterator.RectIterFactory;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.util.CoverageUtilities;
import org.opengis.coverage.CannotEvaluateException;
import org.opengis.coverage.PointOutsideCoverageException;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

public final class Interpolator2D
extends GridCoverage2D {
    protected final GridCoverage2D source;
    private static final long serialVersionUID = 9028980295030908004L;
    private static final float ONE_EPSILON = 0.99999994f;
    private static volatile Interpolation[] DEFAULTS;
    private final MathTransform2D toGrid;
    private final Interpolation interpolation;
    private final Interpolator2D fallback;
    private final int xmin;
    private final int ymin;
    private final int xmax;
    private final int ymax;
    private final int top;
    private final int left;
    private final Rectangle bounds;
    private transient double[][] doubles;
    private transient float[][] floats;
    private transient int[][] ints;
    private final BorderExtender borderExtender;
    private ROI roi;
    private Range nodata;
    private double background;
    private boolean hasROI;
    private boolean hasNoData;
    private Rectangle roiBounds;
    public static int DEFAULT_BORDER_EXTENDER_TYPE;

    public static GridCoverage2D create(GridCoverage2D coverage) {
        if (DEFAULTS == null) {
            DEFAULTS = new Interpolation[]{Interpolation.getInstance(2), Interpolation.getInstance(1), Interpolation.getInstance(0)};
        }
        return Interpolator2D.create(coverage, DEFAULTS);
    }

    public static GridCoverage2D create(GridCoverage2D coverage, Interpolation interpolation) {
        return Interpolator2D.create(coverage, new Interpolation[]{interpolation});
    }

    public static GridCoverage2D create(GridCoverage2D coverage, Interpolation[] interpolations) {
        return Interpolator2D.create(coverage, interpolations, null);
    }

    public static GridCoverage2D create(GridCoverage2D coverage, Interpolation[] interpolations, BorderExtender be) {
        boolean hasNoData;
        while (coverage instanceof Interpolator2D) {
            coverage = ((Interpolator2D)coverage).source;
        }
        ROI roiProp = CoverageUtilities.getROIProperty(coverage);
        boolean hasROI = roiProp != null;
        NoDataContainer noDataProp = CoverageUtilities.getNoDataProperty(coverage);
        boolean bl = hasNoData = noDataProp != null;
        if (interpolations.length == 0 || interpolations[0] instanceof InterpolationNearest && !hasROI && !hasNoData) {
            return coverage;
        }
        return new Interpolator2D(coverage, interpolations, 0, be);
    }

    private Interpolator2D(GridCoverage2D coverage, Interpolation[] interpolations, int index, BorderExtender be) {
        super(null, coverage);
        int top;
        this.source = coverage;
        this.interpolation = interpolations[index];
        this.borderExtender = be == null ? BorderExtender.createInstance(DEFAULT_BORDER_EXTENDER_TYPE) : be;
        this.fallback = index + 1 < interpolations.length ? (interpolations[index + 1] instanceof InterpolationNearest ? this : new Interpolator2D(coverage, interpolations, index + 1, be)) : null;
        if (this.fallback != null && this.fallback != this) {
            this.toGrid = this.fallback.toGrid;
        } else {
            try {
                MathTransform2D transform = this.gridGeometry.getGridToCRS2D(PixelOrientation.UPPER_LEFT);
                this.toGrid = transform.inverse();
            }
            catch (NoninvertibleTransformException exception) {
                throw new IllegalArgumentException(exception);
            }
        }
        int left = this.interpolation.getLeftPadding();
        this.top = top = this.interpolation.getTopPadding();
        this.left = left;
        int x = this.image.getMinX();
        int y = this.image.getMinY();
        this.xmin = x + left;
        this.ymin = y + top;
        this.xmax = x + this.image.getWidth();
        this.ymax = y + this.image.getHeight();
        this.bounds = new Rectangle(0, 0, this.interpolation.getWidth(), this.interpolation.getHeight());
        ROI roiProp = CoverageUtilities.getROIProperty(coverage);
        this.hasROI = roiProp != null;
        NoDataContainer noDataProp = CoverageUtilities.getNoDataProperty(coverage);
        boolean bl = this.hasNoData = noDataProp != null;
        if (this.hasROI) {
            this.roi = roiProp;
            this.roiBounds = this.roi.getBounds();
        }
        this.nodata = this.hasNoData ? noDataProp.getAsRange() : null;
        this.background = this.nodata != null ? this.nodata.getMin(true).doubleValue() : 0.0;
    }

    public Interpolation[] getInterpolations() {
        ArrayList<Interpolation> interp = new ArrayList<Interpolation>(4);
        Interpolator2D scan = this;
        do {
            interp.add(this.interpolation);
            if (scan.fallback != scan) continue;
            interp.add(Interpolation.getInstance(0));
            break;
        } while ((scan = scan.fallback) != null);
        return interp.toArray(new Interpolation[interp.size()]);
    }

    @Override
    public Interpolation getInterpolation() {
        return this.interpolation;
    }

    @Override
    public int[] evaluate(Point2D coord, int[] dest) throws CannotEvaluateException {
        if (this.fallback != null) {
            dest = super.evaluate(coord, dest);
        }
        try {
            Point2D pixel = this.toGrid.transform(coord, null);
            double x = pixel.getX();
            double y = pixel.getY();
            if (!Double.isNaN(x) && !Double.isNaN(y) && (dest = this.interpolate(x, y, dest, 0, this.image.getNumBands())) != null) {
                return dest;
            }
        }
        catch (TransformException exception) {
            throw new CannotEvaluateException(this.formatEvaluateError(coord, false), exception);
        }
        throw new PointOutsideCoverageException(this.formatEvaluateError(coord, true));
    }

    @Override
    public float[] evaluate(Point2D coord, float[] dest) throws CannotEvaluateException {
        if (this.fallback != null) {
            dest = super.evaluate(coord, dest);
        }
        try {
            Point2D pixel = this.toGrid.transform(coord, null);
            double x = pixel.getX();
            double y = pixel.getY();
            if (!Double.isNaN(x) && !Double.isNaN(y) && (dest = this.interpolate(x, y, dest, 0, this.image.getNumBands())) != null) {
                return dest;
            }
        }
        catch (TransformException exception) {
            throw new CannotEvaluateException(this.formatEvaluateError(coord, false), exception);
        }
        throw new PointOutsideCoverageException(this.formatEvaluateError(coord, true));
    }

    @Override
    public double[] evaluate(Point2D coord, double[] dest) throws CannotEvaluateException {
        if (this.fallback != null) {
            dest = super.evaluate(coord, dest);
        }
        try {
            Point2D pixel = this.toGrid.transform(coord, null);
            double x = pixel.getX();
            double y = pixel.getY();
            if (!Double.isNaN(x) && !Double.isNaN(y) && (dest = this.interpolate(x, y, dest, 0, this.image.getNumBands())) != null) {
                return dest;
            }
        }
        catch (TransformException exception) {
            throw new CannotEvaluateException(this.formatEvaluateError(coord, false), exception);
        }
        throw new PointOutsideCoverageException(this.formatEvaluateError(coord, true));
    }

    /*
     * Exception decompiling
     */
    private synchronized double[] interpolate(double x, double y, double[] dest, int band, int bandUp) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:722)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private synchronized float[] interpolate(double x, double y, float[] dest, int band, int bandUp) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:722)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private synchronized int[] interpolate(double x, double y, int[] dest, int band, int bandUp) {
        boolean[][] gaps;
        double x0 = Math.floor(x);
        double y0 = Math.floor(y);
        int ix = (int)x0;
        int iy = (int)y0;
        if (ix < this.xmin || ix >= this.xmax || iy < this.ymin || iy >= this.ymax) {
            return null;
        }
        Object samples = this.ints;
        if (samples == null) {
            int rowCount = this.interpolation.getHeight();
            int colCount = this.interpolation.getWidth();
            int[][] nArrayArray = new int[rowCount][];
            samples = nArrayArray;
            this.ints = nArrayArray;
            for (int i = 0; i < rowCount; ++i) {
                samples[i] = new int[colCount];
            }
        }
        if (dest == null) {
            dest = new int[bandUp];
        }
        if (this.hasROI && !this.roiBounds.contains(ix, iy) && !this.roi.contains(ix, iy)) {
            Arrays.fill(dest, (int)this.background);
            return dest;
        }
        this.bounds.x = ix - this.left;
        this.bounds.y = iy - this.top;
        RectIter iter = RectIterFactory.create(this.image.getExtendedData(this.bounds, this.borderExtender), this.bounds);
        boolean[][] blArray = gaps = this.hasNoData ? new boolean[((int[][])samples).length][samples[0].length] : (boolean[][])null;
        while (band < bandUp) {
            iter.startLines();
            int j = 0;
            do {
                iter.startPixels();
                boolean[] nodLine = this.hasNoData ? gaps[j] : null;
                int[] row = samples[j++];
                int i = 0;
                do {
                    int sample = iter.getSample(band);
                    if (this.hasNoData && !this.nodata.contains(sample)) {
                        nodLine[i] = true;
                    }
                    row[i++] = sample;
                } while (!iter.nextPixelDone());
                assert (i == row.length);
            } while (!iter.nextLineDone());
            assert (j == ((int[][])samples).length);
            boolean result = this.fixNoData((int[][])samples, gaps);
            if (!result) {
                Arrays.fill(dest, (int)this.background);
                return dest;
            }
            int xfrac = (int)((x - x0) * (double)(1 << this.interpolation.getSubsampleBitsH()));
            int yfrac = (int)((y - y0) * (double)(1 << this.interpolation.getSubsampleBitsV()));
            dest[band] = this.interpolation.interpolate((int[][])samples, xfrac, yfrac);
            ++band;
        }
        return dest;
    }

    private boolean fixNoData(int[][] samples, boolean[][] gaps) {
        int i;
        int j;
        int i2;
        if (!this.hasNoData) {
            return true;
        }
        boolean totalValid = true;
        boolean totalInvalid = false;
        boolean[] validLines = new boolean[gaps.length];
        for (i2 = 0; i2 < gaps.length; ++i2) {
            for (j = 0; j < gaps[0].length; ++j) {
                totalValid &= gaps[i2][j];
                totalInvalid |= gaps[i2][j];
                int n = i2;
                validLines[n] = validLines[n] | gaps[i2][j];
            }
        }
        if (totalValid) {
            return true;
        }
        if (!totalInvalid) {
            return false;
        }
        for (i2 = 0; i2 < gaps.length; ++i2) {
            if (!validLines[i2]) continue;
            for (j = 0; j < gaps[0].length; ++j) {
                if (j == 0) {
                    samples[i2][j] = samples[i2][this.searchFirstValid(gaps[i2], j, true)];
                } else if (j == gaps[0].length - 1) {
                    samples[i2][j] = samples[i2][this.searchFirstValid(gaps[i2], j, false)];
                } else {
                    int before = this.searchFirstValid(gaps[i2], j, true);
                    int after = this.searchFirstValid(gaps[i2], j, false);
                    samples[i2][j] = before == -1 ? samples[i2][after] : (after == -1 ? samples[i2][before] : (samples[i2][after] + samples[i2][before]) / 2);
                }
                gaps[i2][j] = true;
            }
        }
        boolean allValid = true;
        for (i = 0; allValid && i < gaps.length; allValid &= validLines[i], ++i) {
        }
        if (allValid) {
            return true;
        }
        for (i = 0; i < gaps.length; ++i) {
            int index;
            if (validLines[i]) continue;
            if (i == 0) {
                index = this.searchFirstValid(validLines, i, true);
                samples[i] = samples[index];
                continue;
            }
            if (i == gaps.length - 1) {
                index = this.searchFirstValid(validLines, i, false);
                samples[i] = samples[index];
                continue;
            }
            int indexAfter = this.searchFirstValid(validLines, i, true);
            int indexBefore = this.searchFirstValid(validLines, i, false);
            if (indexAfter == -1) {
                samples[i] = samples[indexBefore];
                continue;
            }
            if (indexBefore == -1) {
                samples[i] = samples[indexAfter];
                continue;
            }
            for (int j2 = 0; j2 < samples[0].length; ++j2) {
                samples[i][j2] = (samples[indexBefore][j2] + samples[indexAfter][j2]) / 2;
            }
        }
        return true;
    }

    private boolean fixNoData(float[][] samples, boolean[][] gaps) {
        int i;
        int j;
        int i2;
        if (!this.hasNoData) {
            return true;
        }
        boolean totalValid = true;
        boolean totalInvalid = false;
        boolean[] validLines = new boolean[gaps.length];
        for (i2 = 0; i2 < gaps.length; ++i2) {
            for (j = 0; j < gaps[0].length; ++j) {
                totalValid &= gaps[i2][j];
                totalInvalid |= gaps[i2][j];
                int n = i2;
                validLines[n] = validLines[n] | gaps[i2][j];
            }
        }
        if (totalValid) {
            return true;
        }
        if (!totalInvalid) {
            return false;
        }
        for (i2 = 0; i2 < gaps.length; ++i2) {
            if (!validLines[i2]) continue;
            for (j = 0; j < gaps[0].length; ++j) {
                if (j == 0) {
                    samples[i2][j] = samples[i2][this.searchFirstValid(gaps[i2], j, true)];
                } else if (j == gaps[0].length - 1) {
                    samples[i2][j] = samples[i2][this.searchFirstValid(gaps[i2], j, false)];
                } else {
                    int before = this.searchFirstValid(gaps[i2], j, true);
                    int after = this.searchFirstValid(gaps[i2], j, false);
                    samples[i2][j] = before == -1 ? samples[i2][after] : (after == -1 ? samples[i2][before] : (samples[i2][after] + samples[i2][before]) / 2.0f);
                }
                gaps[i2][j] = true;
            }
        }
        boolean allValid = true;
        for (i = 0; allValid && i < gaps.length; allValid &= validLines[i], ++i) {
        }
        if (allValid) {
            return true;
        }
        for (i = 0; i < gaps.length; ++i) {
            int index;
            if (validLines[i]) continue;
            if (i == 0) {
                index = this.searchFirstValid(validLines, i, true);
                samples[i] = samples[index];
                continue;
            }
            if (i == gaps.length - 1) {
                index = this.searchFirstValid(validLines, i, false);
                samples[i] = samples[index];
                continue;
            }
            int indexAfter = this.searchFirstValid(validLines, i, true);
            int indexBefore = this.searchFirstValid(validLines, i, false);
            if (indexAfter == -1) {
                samples[i] = samples[indexBefore];
                continue;
            }
            if (indexBefore == -1) {
                samples[i] = samples[indexAfter];
                continue;
            }
            for (int j2 = 0; j2 < samples[0].length; ++j2) {
                samples[i][j2] = (samples[indexBefore][j2] + samples[indexAfter][j2]) / 2.0f;
            }
        }
        return true;
    }

    private boolean fixNoData(double[][] samples, boolean[][] gaps) {
        int i;
        int j;
        int i2;
        if (!this.hasNoData) {
            return true;
        }
        boolean totalValid = true;
        boolean totalInvalid = false;
        boolean[] validLines = new boolean[gaps.length];
        for (i2 = 0; i2 < gaps.length; ++i2) {
            for (j = 0; j < gaps[0].length; ++j) {
                totalValid &= gaps[i2][j];
                totalInvalid |= gaps[i2][j];
                int n = i2;
                validLines[n] = validLines[n] | gaps[i2][j];
            }
        }
        if (totalValid) {
            return true;
        }
        if (!totalInvalid) {
            return false;
        }
        for (i2 = 0; i2 < gaps.length; ++i2) {
            if (!validLines[i2]) continue;
            for (j = 0; j < gaps[0].length; ++j) {
                if (j == 0) {
                    samples[i2][j] = samples[i2][this.searchFirstValid(gaps[i2], j, true)];
                } else if (j == gaps[0].length - 1) {
                    samples[i2][j] = samples[i2][this.searchFirstValid(gaps[i2], j, false)];
                } else {
                    int before = this.searchFirstValid(gaps[i2], j, true);
                    int after = this.searchFirstValid(gaps[i2], j, false);
                    samples[i2][j] = before == -1 ? samples[i2][after] : (after == -1 ? samples[i2][before] : (samples[i2][after] + samples[i2][before]) / 2.0);
                }
                gaps[i2][j] = true;
            }
        }
        boolean allValid = true;
        for (i = 0; allValid && i < gaps.length; allValid &= validLines[i], ++i) {
        }
        if (allValid) {
            return true;
        }
        for (i = 0; i < gaps.length; ++i) {
            int index;
            if (validLines[i]) continue;
            if (i == 0) {
                index = this.searchFirstValid(validLines, i, true);
                samples[i] = samples[index];
                continue;
            }
            if (i == gaps.length - 1) {
                index = this.searchFirstValid(validLines, i, false);
                samples[i] = samples[index];
                continue;
            }
            int indexAfter = this.searchFirstValid(validLines, i, true);
            int indexBefore = this.searchFirstValid(validLines, i, false);
            if (indexAfter == -1) {
                samples[i] = samples[indexBefore];
                continue;
            }
            if (indexBefore == -1) {
                samples[i] = samples[indexAfter];
                continue;
            }
            for (int j2 = 0; j2 < samples[0].length; ++j2) {
                samples[i][j2] = (samples[indexBefore][j2] + samples[indexAfter][j2]) / 2.0;
            }
        }
        return true;
    }

    private int searchFirstValid(boolean[] gaps, int j, boolean after) {
        int result = -1;
        if (after) {
            for (int k = j + 1; k < gaps.length; ++k) {
                if (!gaps[k]) continue;
                result = k;
                break;
            }
        } else {
            for (int k = gaps.length - 1; k > j; --k) {
                if (!gaps[k]) continue;
                result = k;
                break;
            }
        }
        return result;
    }

    static {
        DEFAULT_BORDER_EXTENDER_TYPE = 1;
    }
}

