/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tracer2;

import java.util.Collection;
import java.util.LinkedList;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;

public class TracerDebug {
    private static String FormatPrimitive(String strIn) {
        while (strIn.contains("{")) {
            strIn = strIn.replace("{", "xxxxx");
        }
        return strIn.replaceAll("xxxxx", "\r\n    {");
    }

    public void OutputOsmPrimitive(Collection<OsmPrimitive> cOsmPrimitive) {
        if (cOsmPrimitive != null) {
            for (OsmPrimitive p : cOsmPrimitive) {
                System.out.println(" OsmPrimitive: " + TracerDebug.FormatPrimitive(p.toString()));
            }
        }
    }

    public void OutputOsmExtendsPrimitive(Collection<? extends OsmPrimitive> cOsmPrimitive) {
        if (cOsmPrimitive != null) {
            for (OsmPrimitive osmPrimitive : cOsmPrimitive) {
                System.out.println(" OsmPrimitive x: " + TracerDebug.FormatPrimitive(osmPrimitive.toString()));
            }
        }
    }

    public void OutputCommands(LinkedList<Command> cmds) {
        for (Command c : cmds) {
            AddCommand x;
            System.out.println("");
            LinkedList<OsmPrimitive> cp1 = null;
            LinkedList<OsmPrimitive> cp2 = null;
            LinkedList<OsmPrimitive> cp3 = null;
            Collection cpx = null;
            LinkedList<OsmPrimitive> lp1 = new LinkedList<OsmPrimitive>();
            LinkedList<OsmPrimitive> lp2 = new LinkedList<OsmPrimitive>();
            LinkedList<OsmPrimitive> lp3 = new LinkedList<OsmPrimitive>();
            LinkedList lp = new LinkedList();
            cp1 = lp1;
            cp2 = lp2;
            cp3 = lp3;
            cpx = lp;
            Way op1 = new Way();
            System.out.println("Command: " + c.toString());
            if (c instanceof AddCommand) {
                x = (AddCommand)c;
                x.fillModifiedData(cp1, cp2, cp3);
                this.OutputOsmPrimitive(cp1);
                this.OutputOsmPrimitive(cp2);
                this.OutputOsmPrimitive(cp3);
                cpx = x.getParticipatingPrimitives();
                this.OutputOsmExtendsPrimitive(cpx);
                continue;
            }
            if (c instanceof ChangeCommand) {
                x = (ChangeCommand)c;
                x.fillModifiedData(cp1, cp2, cp3);
                x.getOrig((OsmPrimitive)op1);
                this.OutputOsmPrimitive(cp1);
                this.OutputOsmPrimitive(cp2);
                this.OutputOsmPrimitive(cp3);
                cpx = x.getParticipatingPrimitives();
                this.OutputOsmExtendsPrimitive(cpx);
                continue;
            }
            if (c instanceof DeleteCommand) {
                x = (DeleteCommand)c;
                x.fillModifiedData(cp1, cp2, cp3);
                this.OutputOsmPrimitive(cp1);
                this.OutputOsmPrimitive(cp2);
                this.OutputOsmPrimitive(cp3);
                cpx = x.getParticipatingPrimitives();
                this.OutputOsmExtendsPrimitive(cpx);
                continue;
            }
            if (c instanceof MoveCommand) {
                x = (MoveCommand)c;
                x.fillModifiedData(cp1, cp2, cp3);
                this.OutputOsmPrimitive(cp1);
                this.OutputOsmPrimitive(cp2);
                this.OutputOsmPrimitive(cp3);
                cpx = x.getParticipatingPrimitives();
                this.OutputOsmExtendsPrimitive(cpx);
                continue;
            }
            c.fillModifiedData(cp1, cp2, cp3);
            this.OutputOsmPrimitive(cp1);
            this.OutputOsmPrimitive(cp2);
            this.OutputOsmPrimitive(cp3);
            cpx = c.getParticipatingPrimitives();
            this.OutputOsmExtendsPrimitive(cpx);
        }
    }
}

