/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.seamapeditor.panels;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.EnumMap;
import java.util.EnumSet;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import org.openstreetmap.josm.plugins.seamapeditor.SmedAction;
import org.openstreetmap.josm.plugins.seamapeditor.messages.Messages;
import org.openstreetmap.josm.plugins.seamapeditor.seamarks.SeaMark;
import org.openstreetmap.josm.tools.I18n;

public class PanelChr
extends JPanel {
    private SmedAction dlg;
    public JLabel col1Label = new JLabel();
    public JLabel col2Label = new JLabel();
    public JLabel charLabel = new JLabel();
    public JTextField charBox = new JTextField();
    public JToggleButton noneButton = PanelChr.newJToggleButton("/images/NoCharButton.png");
    public JToggleButton fixedButton = PanelChr.newJToggleButton("/images/FixedButton.png");
    public JToggleButton flashButton = PanelChr.newJToggleButton("/images/FlashButton.png");
    public JToggleButton longFlashButton = PanelChr.newJToggleButton("/images/LongFlashButton.png");
    public JToggleButton quickButton = PanelChr.newJToggleButton("/images/QuickButton.png");
    public JToggleButton veryQuickButton = PanelChr.newJToggleButton("/images/VeryQuickButton.png");
    public JToggleButton ultraQuickButton = PanelChr.newJToggleButton("/images/UltraQuickButton.png");
    public JToggleButton interruptedQuickButton = PanelChr.newJToggleButton("/images/InterruptedQuickButton.png");
    public JToggleButton interruptedVeryQuickButton = PanelChr.newJToggleButton("/images/InterruptedVeryQuickButton.png");
    public JToggleButton interruptedUltraQuickButton = PanelChr.newJToggleButton("/images/InterruptedUltraQuickButton.png");
    public JToggleButton isophasedButton = PanelChr.newJToggleButton("/images/IsophasedButton.png");
    public JToggleButton occultingButton = PanelChr.newJToggleButton("/images/OccultingButton.png");
    public JToggleButton morseButton = PanelChr.newJToggleButton("/images/MorseButton.png");
    public JToggleButton alternatingButton = PanelChr.newJToggleButton("/images/AlternatingButton.png");
    private EnumMap<SeaMark.Chr, JToggleButton> buttons = new EnumMap(SeaMark.Chr.class);
    private ActionListener alCharButton = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JToggleButton button;
            JToggleButton source = (JToggleButton)e.getSource();
            EnumSet<SeaMark.Chr> combo = EnumSet.noneOf(SeaMark.Chr.class);
            for (SeaMark.Chr chr : PanelChr.this.buttons.keySet()) {
                button = (JToggleButton)PanelChr.this.buttons.get((Object)chr);
                if (button.isSelected()) {
                    combo.add(chr);
                    button.setBorderPainted(true);
                    continue;
                }
                combo.remove((Object)chr);
                button.setBorderPainted(false);
            }
            if (SeaMark.ChrMAP.containsKey(combo)) {
                PanelChr.this.charBox.setText(SeaMark.ChrMAP.get(combo));
            } else {
                for (SeaMark.Chr chr : PanelChr.this.buttons.keySet()) {
                    button = (JToggleButton)PanelChr.this.buttons.get((Object)chr);
                    if (button == source) {
                        PanelChr.this.charBox.setText(SeaMark.ChrMAP.get(EnumSet.of(chr)));
                        button.setSelected(true);
                        button.setBorderPainted(true);
                        continue;
                    }
                    button.setSelected(false);
                    button.setBorderPainted(false);
                }
            }
            String str = PanelChr.this.charBox.getText();
            SmedAction.panelMain.mark.setLightAtt(SeaMark.Att.CHR, 0, (Object)str);
            if (!str.contains("Al")) {
                PanelChr.this.col2Label.setBackground(SeaMark.ColMAP.get(SmedAction.panelMain.mark.getLightAtt(SeaMark.Att.COL, 0)));
                SmedAction.panelMain.mark.setLightAtt(SeaMark.Att.ALT, 0, (Object)SeaMark.Col.UNKCOL);
            } else {
                PanelChr.this.col2Label.setBackground(SeaMark.ColMAP.get(SmedAction.panelMain.mark.getLightAtt(SeaMark.Att.ALT, 0)));
            }
        }
    };
    private FocusListener flCharBox = new FocusListener(){

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            String str = PanelChr.this.charBox.getText();
            SmedAction.panelMain.mark.setLightAtt(SeaMark.Att.CHR, 0, (Object)str);
            EnumSet<SeaMark.Chr> set = EnumSet.noneOf(SeaMark.Chr.class);
            for (EnumSet<SeaMark.Chr> map : SeaMark.ChrMAP.keySet()) {
                if (!str.equals(SeaMark.ChrMAP.get(map))) continue;
                set = map;
                break;
            }
            for (SeaMark.Chr chr : PanelChr.this.buttons.keySet()) {
                JToggleButton button = (JToggleButton)PanelChr.this.buttons.get((Object)chr);
                if (set.contains((Object)chr)) {
                    button.setSelected(true);
                    button.setBorderPainted(true);
                    continue;
                }
                button.setSelected(false);
                button.setBorderPainted(false);
            }
            if (!str.contains("Al")) {
                PanelChr.this.col2Label.setBackground(SeaMark.ColMAP.get(SmedAction.panelMain.mark.getLightAtt(SeaMark.Att.COL, 0)));
                SmedAction.panelMain.mark.setLightAtt(SeaMark.Att.ALT, 0, (Object)SeaMark.Col.UNKCOL);
            } else {
                PanelChr.this.col2Label.setBackground(SeaMark.ColMAP.get(SmedAction.panelMain.mark.getLightAtt(SeaMark.Att.ALT, 0)));
            }
        }
    };

    public PanelChr(SmedAction dia) {
        this.dlg = dia;
        this.setLayout(null);
        this.add(this.getChrButton(this.noneButton, 0, 0, 44, 16, Messages.getString("NoChar"), SeaMark.Chr.UNKCHR));
        this.add(this.getChrButton(this.fixedButton, 0, 16, 44, 16, Messages.getString("FChar"), SeaMark.Chr.FIXED));
        this.add(this.getChrButton(this.flashButton, 0, 32, 44, 16, Messages.getString("FlChar"), SeaMark.Chr.FLASH));
        this.add(this.getChrButton(this.longFlashButton, 0, 48, 44, 16, Messages.getString("LFlChar"), SeaMark.Chr.LFLASH));
        this.add(this.getChrButton(this.quickButton, 0, 64, 44, 16, Messages.getString("QChar"), SeaMark.Chr.QUICK));
        this.add(this.getChrButton(this.veryQuickButton, 0, 80, 44, 16, Messages.getString("VQChar"), SeaMark.Chr.VQUICK));
        this.add(this.getChrButton(this.ultraQuickButton, 0, 96, 44, 16, Messages.getString("UQChar"), SeaMark.Chr.UQUICK));
        this.add(this.getChrButton(this.alternatingButton, 44, 0, 44, 16, Messages.getString("AlChar"), SeaMark.Chr.ALTERNATING));
        this.add(this.getChrButton(this.isophasedButton, 44, 16, 44, 16, Messages.getString("IsoChar"), SeaMark.Chr.ISOPHASED));
        this.add(this.getChrButton(this.occultingButton, 44, 32, 44, 16, Messages.getString("OcChar"), SeaMark.Chr.OCCULTING));
        this.add(this.getChrButton(this.morseButton, 44, 48, 44, 16, Messages.getString("MoChar"), SeaMark.Chr.MORSE));
        this.add(this.getChrButton(this.interruptedQuickButton, 44, 64, 44, 16, Messages.getString("IQChar"), SeaMark.Chr.IQUICK));
        this.add(this.getChrButton(this.interruptedVeryQuickButton, 44, 80, 44, 16, Messages.getString("IVQChar"), SeaMark.Chr.IVQUICK));
        this.add(this.getChrButton(this.interruptedUltraQuickButton, 44, 96, 44, 16, Messages.getString("IUQChar"), SeaMark.Chr.IUQUICK));
        this.charLabel.setBounds(new Rectangle(0, 113, 88, 20));
        this.charLabel.setHorizontalAlignment(0);
        this.charLabel.setText(Messages.getString("Character"));
        this.add(this.charLabel);
        this.col1Label.setBounds(new Rectangle(10, 135, 10, 20));
        this.col1Label.setOpaque(true);
        this.add(this.col1Label);
        this.col2Label.setBounds(new Rectangle(70, 135, 10, 20));
        this.col2Label.setOpaque(true);
        this.add(this.col2Label);
        this.charBox.setBounds(new Rectangle(20, 135, 50, 20));
        this.charBox.setHorizontalAlignment(0);
        this.add(this.charBox);
        this.charBox.addFocusListener(this.flCharBox);
    }

    private static JToggleButton newJToggleButton(String buttonIcon) {
        return new JToggleButton(new ImageIcon(PanelChr.class.getResource(buttonIcon)));
    }

    public void syncPanel() {
        String str = (String)SmedAction.panelMain.mark.getLightAtt(SeaMark.Att.CHR, 0);
        this.charBox.setText(str);
        EnumSet<SeaMark.Chr> set = EnumSet.noneOf(SeaMark.Chr.class);
        for (EnumSet<SeaMark.Chr> map : SeaMark.ChrMAP.keySet()) {
            if (this.dlg.node == null || !str.equals(SeaMark.ChrMAP.get(map))) continue;
            set = map;
            break;
        }
        if (!str.contains("Al")) {
            this.col2Label.setBackground(SeaMark.ColMAP.get(SmedAction.panelMain.mark.getLightAtt(SeaMark.Att.COL, 0)));
        } else {
            this.col2Label.setBackground(SeaMark.ColMAP.get(SmedAction.panelMain.mark.getLightAtt(SeaMark.Att.ALT, 0)));
        }
        this.col1Label.setBackground(SeaMark.ColMAP.get(SmedAction.panelMain.mark.getLightAtt(SeaMark.Att.COL, 0)));
        for (SeaMark.Chr chr : this.buttons.keySet()) {
            JToggleButton button = this.buttons.get((Object)chr);
            if (set.contains((Object)chr)) {
                button.setSelected(true);
                button.setBorderPainted(true);
                continue;
            }
            button.setSelected(false);
            button.setBorderPainted(false);
        }
    }

    private JToggleButton getChrButton(JToggleButton button, int x, int y, int w, int h, String tip, SeaMark.Chr chr) {
        button.setBounds(new Rectangle(x, y, w, h));
        button.setBorder(BorderFactory.createLoweredBevelBorder());
        button.setBorderPainted(false);
        button.setToolTipText(I18n.tr((String)tip, (Object[])new Object[0]));
        button.addActionListener(this.alCharButton);
        this.buttons.put(chr, button);
        return button;
    }
}

