/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnlanes.gui;

import java.awt.geom.PathIterator;
import java.util.Arrays;

final class ReversePathIterator
implements PathIterator {
    private static final int[] COUNTS = new int[]{2, 2, 4, 6, 0};
    private final int winding;
    private final int[] types;
    private int typesIndex = 0;
    private final double[] coords;
    private int coordsIndex = 0;

    public static ReversePathIterator reverse(PathIterator it) {
        return new ReversePathIterator(it);
    }

    private static int[] reverseTypes(int[] types, int length) {
        if (length > 0 && types[0] != 0) {
            throw new IllegalArgumentException("Can not reverse path without initial SEG_MOVETO.");
        }
        int[] result = new int[length];
        result[0] = 0;
        int lower = 1;
        for (int upper = length - 1; lower <= upper; ++lower, --upper) {
            result[lower] = types[upper];
            result[upper] = types[lower];
        }
        return result;
    }

    private static double[] reverseCoords(double[] coords, int length) {
        double[] result = new double[length];
        int lower = 0;
        for (int upper = length - 2; lower <= upper; lower += 2, upper -= 2) {
            result[lower] = coords[upper];
            result[lower + 1] = coords[upper + 1];
            result[upper] = coords[lower];
            result[upper + 1] = coords[lower + 1];
        }
        return result;
    }

    private ReversePathIterator(PathIterator it) {
        this.winding = it.getWindingRule();
        double[] tmpCoords = new double[62];
        int[] tmpTypes = new int[11];
        int tmpCoordsI = 0;
        int tmpTypesI = 0;
        while (!it.isDone()) {
            if (tmpTypesI >= tmpTypes.length) {
                tmpTypes = Arrays.copyOf(tmpTypes, 2 * tmpTypes.length);
            }
            double[] cs = new double[6];
            int t = it.currentSegment(cs);
            tmpTypes[tmpTypesI++] = t;
            int count = COUNTS[t];
            if (tmpCoordsI + count > tmpCoords.length) {
                tmpCoords = Arrays.copyOf(tmpCoords, 2 * tmpCoords.length);
            }
            System.arraycopy(cs, 0, tmpCoords, tmpCoordsI, count);
            tmpCoordsI += count;
            it.next();
        }
        this.types = ReversePathIterator.reverseTypes(tmpTypes, tmpTypesI);
        this.coords = ReversePathIterator.reverseCoords(tmpCoords, tmpCoordsI);
    }

    @Override
    public int getWindingRule() {
        return this.winding;
    }

    @Override
    public boolean isDone() {
        return this.typesIndex >= this.types.length;
    }

    @Override
    public void next() {
        this.coordsIndex += COUNTS[this.types[this.typesIndex]];
        ++this.typesIndex;
    }

    @Override
    public int currentSegment(float[] coords) {
        double[] tmp = new double[6];
        int type = this.currentSegment(tmp);
        coords[0] = (float)tmp[0];
        coords[1] = (float)tmp[1];
        coords[2] = (float)tmp[2];
        coords[3] = (float)tmp[3];
        coords[4] = (float)tmp[4];
        coords[5] = (float)tmp[5];
        return type;
    }

    @Override
    public int currentSegment(double[] coords) {
        int type = this.types[this.typesIndex];
        System.arraycopy(this.coords, this.coordsIndex, coords, 0, COUNTS[type]);
        return type;
    }
}

