/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.importvec;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.io.importexport.FileImporter;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.plugins.importvec.ImportDialog;
import org.openstreetmap.josm.plugins.importvec.SvgImportTask;
import org.openstreetmap.josm.tools.I18n;

public class SvgImporter
extends FileImporter {
    public SvgImporter() {
        super(new ExtensionFileFilter("svg", "svg", I18n.tr((String)"SVG files [ImportVec plugin] (*.svg)", (Object[])new Object[0])));
    }

    public boolean isBatchImporter() {
        return true;
    }

    public void importData(List<File> files, ProgressMonitor progressMonitor) throws IOException, IllegalDataException {
        if (MainApplication.getLayerManager().getEditLayer() == null) {
            JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Please open or create data layer before importing", (Object[])new Object[0]));
            return;
        }
        ImportDialog dlg = new ImportDialog();
        if (dlg.getValue() != 1) {
            return;
        }
        dlg.saveSettings();
        MainApplication.worker.submit((Runnable)((Object)new SvgImportTask(files)));
    }
}

