/*
 * Decompiled with CFR 0.152.
 */
package org.kaintoch.gps.globalsat.dg100;

import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class GpsRec {
    private int dg100Latitude = -1;
    private int dg100Longitude = -1;
    private int dg100TimeZ = -1;
    private int dg100Date = -1;
    private int dg100Speed = -1;
    private int dg100Altitude = -1;
    private int dg100Unk1 = -1;
    private int dg100TypeOfCurRec = -1;
    private int dg100TypeOfNextRec = -1;
    private Calendar dateTime = null;

    public GpsRec() {
        this.dg100TypeOfNextRec = 2;
        this.dg100TypeOfCurRec = 2;
        this.dg100Latitude = 0;
        this.dg100Longitude = 0;
        this.dg100TimeZ = 0;
        this.dg100Date = 0;
        this.dg100Speed = 0;
        this.dg100Altitude = 0;
        this.dg100Unk1 = -1;
        this.dateTime = null;
    }

    public void copy(GpsRec init) {
        this.dg100TypeOfNextRec = init.dg100TypeOfNextRec;
        this.dg100TypeOfCurRec = init.dg100TypeOfCurRec;
        this.dg100Latitude = init.dg100Latitude;
        this.dg100Longitude = init.dg100Longitude;
        this.dg100TimeZ = init.dg100TimeZ;
        this.dg100Date = init.dg100Date;
        this.dg100Speed = init.dg100Speed;
        this.dg100Altitude = init.dg100Altitude;
        this.dg100Unk1 = init.dg100Unk1;
        this.dateTime = init.dateTime;
    }

    public GpsRec(GpsRec init) {
        this.copy(init);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.dg100Altitude;
        result = 31 * result + this.dg100Date;
        result = 31 * result + this.dg100Latitude;
        result = 31 * result + this.dg100Longitude;
        result = 31 * result + this.dg100Speed;
        result = 31 * result + this.dg100TimeZ;
        result = 31 * result + this.dg100TypeOfCurRec;
        result = 31 * result + this.dg100TypeOfNextRec;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GpsRec other = (GpsRec)obj;
        return this.dg100Altitude == other.dg100Altitude && this.dg100Date == other.dg100Date && this.dg100Latitude == other.dg100Latitude && this.dg100Longitude == other.dg100Longitude && this.dg100Speed == other.dg100Speed && this.dg100TimeZ == other.dg100TimeZ && this.dg100TypeOfCurRec == other.dg100TypeOfCurRec && this.dg100TypeOfNextRec == other.dg100TypeOfNextRec;
    }

    public GpsRec(ByteBuffer buf, int recType) {
        this.dg100Latitude = buf.getInt();
        this.dg100Longitude = buf.getInt();
        this.dg100TypeOfNextRec = recType;
        this.dg100TypeOfCurRec = recType;
        this.dateTime = null;
        if (this.dg100TypeOfNextRec >= 1) {
            this.dg100TimeZ = buf.getInt();
            this.dg100Date = buf.getInt();
            this.calcDateTime();
            this.dg100Speed = buf.getInt();
            if (this.dg100TypeOfNextRec >= 1) {
                this.dg100Altitude = buf.getInt();
                this.dg100Unk1 = buf.getInt();
                this.dg100TypeOfNextRec = buf.getInt();
            }
        }
    }

    public boolean isValid() {
        return this.dg100Latitude <= 360000000 && this.dg100Latitude >= 0 && this.dg100Longitude <= 360000000 && this.dg100Longitude >= 0 && this.dg100TimeZ >= 0 && this.dg100TimeZ <= 240000 && this.dg100Unk1 >= 0 && this.dg100Unk1 <= 1;
    }

    public int getDg100TypeOfNextRec() {
        return this.dg100TypeOfNextRec;
    }

    public int getDg100TypeOfCurRec() {
        return this.dg100TypeOfCurRec;
    }

    public String toString() {
        return "[GpsRec:  Lat = " + this.dg100Latitude + ", Long = " + this.dg100Longitude + ", TimeZ = " + this.dg100TimeZ + ", Date = " + this.dg100Date + ", Speed = " + this.dg100Speed + ", Alt = " + this.dg100Altitude + ", Unk1 = " + this.dg100Unk1 + ", TypeOfCurRec = " + this.dg100TypeOfCurRec + ", TypeOfNextRec = " + this.dg100TypeOfNextRec + "]";
    }

    public int getDg100Latitude() {
        return this.dg100Latitude;
    }

    public String toGpxTrkpt() {
        StringBuffer buf = new StringBuffer(500);
        buf.append("<trkpt");
        buf.append(" lat=\"").append(this.getLatitude()).append("\"");
        buf.append(" lon=\"").append(this.getLongitude()).append("\"");
        buf.append(">");
        if (this.dg100TypeOfCurRec > 0) {
            if (this.dg100TypeOfCurRec > 1) {
                buf.append("<ele>").append(this.getAltitude()).append("</ele>");
            }
            buf.append("<time>").append(this.getStringZuluTime()).append("</time>");
            buf.append("<speed>").append(this.getSpeed()).append("</speed>");
        }
        buf.append("</trkpt>");
        return buf.toString();
    }

    public String toGpxWpt() {
        StringBuffer buf = new StringBuffer(500);
        buf.append("<wpt");
        buf.append(" lat=\"").append(this.getLatitude()).append("\"");
        buf.append(" lon=\"").append(this.getLongitude()).append("\"");
        buf.append(">");
        if (this.dg100TypeOfCurRec > 0) {
            if (this.dg100TypeOfCurRec > 1) {
                buf.append("<ele>").append(this.getAltitude()).append("</ele>");
            }
            buf.append("<time>").append(this.getStringZuluTime()).append("</time>");
        }
        buf.append("</wpt>");
        return buf.toString();
    }

    private double toDegree(int gsLatOrLon) {
        int scale = 1000000;
        double deg = 9999.9999;
        double degScaled = gsLatOrLon / scale;
        double minScaled = ((double)gsLatOrLon - degScaled * (double)scale) / 600000.0;
        deg = degScaled + minScaled;
        return deg;
    }

    public String getStringZuluTime() {
        return this.getStringDateTime("yyyy-MM-dd'T'HH:mm:ss'Z'");
    }

    public String getStringDateTime() {
        return this.getStringDateTime("yyyyMMddHHmmss");
    }

    private String getStringDateTime(String dateTimeFormat) {
        String dateTimeString = "???";
        if (this.dateTime != null) {
            SimpleDateFormat sdf = new SimpleDateFormat(dateTimeFormat);
            dateTimeString = sdf.format(this.dateTime.getTime());
        }
        return dateTimeString;
    }

    public int getDg100Altitude() {
        return this.dg100Altitude;
    }

    private void setDg100Altitude(int altitude) {
        this.dg100Altitude = altitude;
    }

    public int getDg100Date() {
        return this.dg100Date;
    }

    private void setDg100Date(int date) {
        this.dg100Date = date;
        this.calcDateTime();
    }

    private void calcDateTime() {
        int hh = this.dg100TimeZ / 10000;
        int mm = (this.dg100TimeZ - hh * 10000) / 100;
        int ss = this.dg100TimeZ - hh * 10000 - mm * 100;
        int DD = this.dg100Date / 10000;
        int MM = (this.dg100Date - DD * 10000) / 100;
        int YY = this.dg100Date - DD * 10000 - MM * 100;
        this.dateTime = GregorianCalendar.getInstance();
        this.dateTime.set(2000 + YY, MM - 1, DD, hh, mm, ss);
    }

    public int getDg100Longitude() {
        return this.dg100Longitude;
    }

    private void setDg100Longitude(int longitude) {
        this.dg100Longitude = longitude;
    }

    public int getDg100Speed() {
        return this.dg100Speed;
    }

    private void setDg100Speed(int speed) {
        this.dg100Speed = speed;
    }

    public int getDg100TimeZ() {
        return this.dg100TimeZ;
    }

    private void setDg100TimeZ(int timeZ) {
        this.dg100TimeZ = timeZ;
        this.calcDateTime();
    }

    private void setDg100Latitude(int latitude) {
        this.dg100Latitude = latitude;
    }

    public void updateMin(GpsRec next) {
        if (next != null) {
            if (next.getDg100Latitude() < this.getDg100Latitude()) {
                this.setDg100Latitude(next.getDg100Latitude());
            }
            if (next.getDg100Longitude() < this.getDg100Longitude()) {
                this.setDg100Longitude(next.getDg100Longitude());
            }
            if (next.getDg100Altitude() < this.getDg100Altitude()) {
                this.setDg100Altitude(next.getDg100Altitude());
            }
            if (next.getDg100Date() < this.getDg100Date() || next.getDg100Date() == this.getDg100Date() && next.getDg100TimeZ() < this.getDg100TimeZ()) {
                this.setDg100Date(next.getDg100Date());
                this.setDg100TimeZ(next.getDg100TimeZ());
            }
            if (next.getDg100Speed() < this.getDg100Speed()) {
                this.setDg100Speed(next.getDg100Speed());
            }
        }
    }

    public void updateMax(GpsRec next) {
        if (next != null) {
            if (next.getDg100Latitude() > this.getDg100Latitude()) {
                this.setDg100Latitude(next.getDg100Latitude());
            }
            if (next.getDg100Longitude() > this.getDg100Longitude()) {
                this.setDg100Longitude(next.getDg100Longitude());
            }
            if (next.getDg100Altitude() > this.getDg100Altitude()) {
                this.setDg100Altitude(next.getDg100Altitude());
            }
            if (next.getDg100Date() > this.getDg100Date() || next.getDg100Date() == this.getDg100Date() && next.getDg100TimeZ() > this.getDg100TimeZ()) {
                this.setDg100Date(next.getDg100Date());
                this.setDg100TimeZ(next.getDg100TimeZ());
            }
            if (next.getDg100Speed() > this.getDg100Speed()) {
                this.setDg100Speed(next.getDg100Speed());
            }
        }
    }

    public Calendar getDateTime() {
        return this.dateTime;
    }

    public double getLatitude() {
        return this.toDegree(this.dg100Latitude);
    }

    public double getLongitude() {
        return this.toDegree(this.dg100Longitude);
    }

    public double getAltitude() {
        return (double)this.dg100Altitude / 10000.0;
    }

    public double getSpeed() {
        return (double)this.dg100Speed / 360.0;
    }
}

