/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.dense.row.decomposition.bidiagonal;

import org.ejml.data.FMatrixRMaj;
import org.ejml.dense.row.SpecializedOps_FDRM;
import org.ejml.simple.SimpleMatrix;

public class BidiagonalDecompositionNaive_FDRM {
    private SimpleMatrix U;
    private SimpleMatrix B;
    private SimpleMatrix V;
    private int m;
    private int n;
    private int min;
    FMatrixRMaj u;

    public SimpleMatrix getU() {
        return this.U;
    }

    public SimpleMatrix getB() {
        return this.B;
    }

    public SimpleMatrix getV() {
        return this.V;
    }

    public boolean decompose(FMatrixRMaj A) {
        this.init(A);
        return this._decompose();
    }

    protected void init(FMatrixRMaj A) {
        this.m = A.numRows;
        this.n = A.numCols;
        this.min = Math.min(this.m, this.n);
        this.U = SimpleMatrix.identity(this.m, FMatrixRMaj.class);
        this.B = new SimpleMatrix(A);
        this.V = SimpleMatrix.identity(this.n, FMatrixRMaj.class);
        int max = Math.max(this.m, this.n);
        this.u = new FMatrixRMaj(max, 1);
    }

    private boolean _decompose() {
        for (int k = 0; k < this.min; ++k) {
            this.computeU(k);
            this.computeV(k);
        }
        return true;
    }

    protected void computeU(int k) {
        this.u.reshape(this.m, 1, false);
        float[] u = this.u.data;
        float max = 0.0f;
        for (int i = k; i < this.m; ++i) {
            float val = u[i] = (float)this.B.get(i, k);
            if (!((val = Math.abs(val)) > max)) continue;
            max = val;
        }
        if (max > 0.0f) {
            float tau = 0.0f;
            int i = k;
            while (i < this.m) {
                int n = i++;
                float f = u[n] / max;
                u[n] = f;
                float val = f;
                tau += val * val;
            }
            tau = (float)Math.sqrt(tau);
            if (u[k] < 0.0f) {
                tau = -tau;
            }
            float nu = u[k] + tau;
            u[k] = 1.0f;
            int i2 = k + 1;
            while (i2 < this.m) {
                int n = i2++;
                u[n] = u[n] / nu;
            }
            SimpleMatrix Q_k = SimpleMatrix.wrap(SpecializedOps_FDRM.createReflector(this.u, nu / tau));
            this.U = this.U.mult(Q_k);
            this.B = Q_k.mult(this.B);
        }
    }

    protected void computeV(int k) {
        this.u.reshape(this.n, 1, false);
        this.u.zero();
        float[] u = this.u.data;
        float max = 0.0f;
        for (int i = k + 1; i < this.n; ++i) {
            float val = u[i] = (float)this.B.get(k, i);
            if (!((val = Math.abs(val)) > max)) continue;
            max = val;
        }
        if (max > 0.0f) {
            float tau = 0.0f;
            int i = k + 1;
            while (i < this.n) {
                int n = i++;
                float f = u[n] / max;
                u[n] = f;
                float val = f;
                tau += val * val;
            }
            tau = (float)Math.sqrt(tau);
            if (u[k + 1] < 0.0f) {
                tau = -tau;
            }
            float nu = u[k + 1] + tau;
            u[k + 1] = 1.0f;
            int i2 = k + 2;
            while (i2 < this.n) {
                int n = i2++;
                u[n] = u[n] / nu;
            }
            SimpleMatrix Q_k = SimpleMatrix.wrap(SpecializedOps_FDRM.createReflector(this.u, nu / tau));
            this.V = this.V.mult(Q_k);
            this.B = this.B.mult(Q_k);
        }
    }
}

