/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fixAddresses.gui;

import java.util.Collections;
import org.openstreetmap.josm.plugins.fixAddresses.AddressEditContainer;
import org.openstreetmap.josm.plugins.fixAddresses.IOSMEntity;
import org.openstreetmap.josm.plugins.fixAddresses.OSMAddress;
import org.openstreetmap.josm.plugins.fixAddresses.gui.AddressEditTableModel;
import org.openstreetmap.josm.tools.I18n;

public class UnresolvedAddressesTableModel
extends AddressEditTableModel {
    private static final int NUMBER_OF_COLUMNS = 5;
    private static final String[] COLUMN_NAMES = new String[]{I18n.tr((String)"Street", (Object[])new Object[0]), I18n.tr((String)"Number", (Object[])new Object[0]), I18n.trc((String)"address", (String)"City"), I18n.tr((String)"Postcode", (Object[])new Object[0]), I18n.tr((String)"Name", (Object[])new Object[0])};
    private static final Class<?>[] COLUMN_CLASSES = new Class[]{String.class, String.class, String.class, String.class, String.class};
    private static final long serialVersionUID = 424009321818130586L;

    public UnresolvedAddressesTableModel(AddressEditContainer addressContainer) {
        super(addressContainer);
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    @Override
    public int getRowCount() {
        if (this.addressContainer == null || this.addressContainer.getUnresolvedAddresses() == null) {
            return 0;
        }
        return this.addressContainer.getNumberOfUnresolvedAddresses();
    }

    @Override
    public Object getValueAt(int row, int column) {
        OSMAddress aNode = (OSMAddress)this.getEntityOfRow(row);
        if (aNode == null) {
            return null;
        }
        switch (column) {
            case 0: {
                return aNode.getStreetName();
            }
            case 1: {
                return aNode.getHouseNumber();
            }
            case 2: {
                return aNode.getCity();
            }
            case 3: {
                return aNode.getPostalCode();
            }
            case 4: {
                return aNode.getName();
            }
        }
        throw new RuntimeException("Invalid column index: " + column);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return COLUMN_CLASSES[columnIndex];
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public IOSMEntity getEntityOfRow(int row) {
        if (this.addressContainer == null || this.addressContainer.getUnresolvedAddresses() == null) {
            return null;
        }
        if (row < 0 || row >= this.addressContainer.getNumberOfUnresolvedAddresses()) {
            return null;
        }
        return this.addressContainer.getUnresolvedAddresses().get(row);
    }

    @Override
    public int getRowOfEntity(IOSMEntity entity) {
        if (this.addressContainer == null || this.addressContainer.getUnresolvedAddresses() == null) {
            return -1;
        }
        return this.addressContainer.getUnresolvedAddresses().indexOf(entity);
    }

    @Override
    protected void sortByColumn(int column, boolean ascending) {
        if (this.addressContainer.getNumberOfUnresolvedAddresses() == 0) {
            return;
        }
        Collections.sort(this.addressContainer.getUnresolvedAddresses(), new UnresolvedAddressModelSorter(column, ascending));
    }

    static class UnresolvedAddressModelSorter
    extends AddressEditTableModel.ColumnSorter<OSMAddress> {
        UnresolvedAddressModelSorter(int column, boolean asc) {
            super(column, asc);
        }

        @Override
        public int compare(OSMAddress o1, OSMAddress o2) {
            int cc = 0;
            switch (this.getColumn()) {
                case 0: {
                    cc = o1.getStreetName().compareTo(o2.getStreetName());
                    break;
                }
                case 1: {
                    cc = o1.getHouseNumber().compareTo(o2.getHouseNumber());
                    break;
                }
                case 2: {
                    cc = o1.getCity().compareTo(o2.getCity());
                    break;
                }
                case 3: {
                    cc = o1.getPostalCode().compareTo(o2.getPostalCode());
                    break;
                }
                case 4: {
                    cc = o1.getName().compareTo(o2.getName());
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid column index: " + this.getColumn());
                }
            }
            if (!this.isAscending()) {
                cc = -cc;
            }
            return cc;
        }
    }
}

