/*
 * Decompiled with CFR 0.152.
 */
package tec.units.indriya.unit;

import java.util.Map;
import javax.measure.Dimension;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import tec.units.indriya.AbstractUnit;

public final class CompoundUnit<Q extends Quantity<Q>>
extends AbstractUnit<Q> {
    private static final long serialVersionUID = -6588505921476784171L;
    private final Unit<Q> upper;
    private final Unit<Q> lower;

    public CompoundUnit(Unit<Q> up, Unit<Q> low) {
        if (!up.getSystemUnit().equals(low.getSystemUnit())) {
            throw new IllegalArgumentException("Both units do not have the same system unit");
        }
        this.upper = up;
        this.lower = low;
    }

    public Unit<Q> getLower() {
        return this.lower;
    }

    public Unit<Q> getUpper() {
        return this.upper;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CompoundUnit) {
            CompoundUnit thatUnit = (CompoundUnit)obj;
            return this.upper.equals(thatUnit.upper) && this.lower.equals(thatUnit.lower);
        }
        if (obj instanceof AbstractUnit) {
            return AbstractUnit.Equalizer.areEqual(this, (AbstractUnit)obj);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.upper.hashCode() ^ this.lower.hashCode();
    }

    @Override
    public UnitConverter getSystemConverter() {
        return ((AbstractUnit)this.lower).getSystemConverter();
    }

    @Override
    protected Unit<Q> toSystemUnit() {
        return this.lower.getSystemUnit();
    }

    @Override
    public Map<? extends Unit<?>, Integer> getBaseUnits() {
        return this.lower.getBaseUnits();
    }

    @Override
    public Dimension getDimension() {
        return this.lower.getDimension();
    }
}

