/*
 * Decompiled with CFR 0.152.
 */
package tec.units.indriya.unit;

import java.util.Map;
import java.util.Objects;
import javax.measure.Dimension;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import tec.units.indriya.AbstractUnit;

public final class AlternateUnit<Q extends Quantity<Q>>
extends AbstractUnit<Q> {
    private static final long serialVersionUID = 4696690756456282705L;
    private final Unit<?> parentUnit;
    private final String symbol;

    public AlternateUnit(Unit<?> parentUnit, String symbol) {
        if (!((AbstractUnit)parentUnit).isSystemUnit()) {
            throw new IllegalArgumentException("The parent unit: " + parentUnit + " is not an unscaled SI unit");
        }
        this.parentUnit = parentUnit instanceof AlternateUnit ? ((AlternateUnit)parentUnit).getParentUnit() : parentUnit;
        this.symbol = symbol;
    }

    public Unit<?> getParentUnit() {
        return this.parentUnit;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public Dimension getDimension() {
        return this.parentUnit.getDimension();
    }

    @Override
    public UnitConverter getSystemConverter() {
        return ((AbstractUnit)this.parentUnit).getSystemConverter();
    }

    @Override
    public Unit<Q> toSystemUnit() {
        return this;
    }

    @Override
    public Map<? extends Unit<?>, Integer> getBaseUnits() {
        return this.parentUnit.getBaseUnits();
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.symbol);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AlternateUnit) {
            AlternateUnit that = (AlternateUnit)obj;
            return Objects.equals(this.parentUnit, that.parentUnit) && Objects.equals(this.symbol, that.symbol);
        }
        if (obj instanceof AbstractUnit) {
            return AbstractUnit.Equalizer.areEqual(this, (AbstractUnit)obj);
        }
        return false;
    }
}

