/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.epsg.hsql;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.sql.DataSource;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.hsqldb.jdbc.JDBCDataSource;
import org.opengis.referencing.FactoryException;

public class HsqlEpsgDatabase {
    public static final String DIRECTORY_KEY = "EPSG-HSQL.directory";
    public static final String DATABASE_NAME = "EPSG";

    public static DataSource createDataSource() throws SQLException {
        return HsqlEpsgDatabase.createDataSource(HsqlEpsgDatabase.getDirectory());
    }

    public static DataSource createDataSource(Hints hints) throws FactoryException {
        try {
            return HsqlEpsgDatabase.createDataSource(HsqlEpsgDatabase.getDirectory());
        }
        catch (SQLException e) {
            throw new FactoryException(e);
        }
    }

    public static DataSource createDataSource(File directory) throws SQLException {
        JDBCDataSource dataSource = new JDBCDataSource();
        StringBuilder url = new StringBuilder("jdbc:hsqldb:file:");
        String path = directory.getAbsolutePath().replace(File.separatorChar, '/');
        if (path.length() == 0 || path.charAt(0) != '/') {
            url.append('/');
        }
        url.append(path);
        if (url.charAt(url.length() - 1) != '/') {
            url.append('/');
        }
        url.append(DATABASE_NAME);
        dataSource.setDatabase(url.toString());
        dataSource.setUser("SA");
        if (!HsqlEpsgDatabase.dataExists(dataSource)) {
            HsqlEpsgDatabase.generateData(dataSource);
            try {
                HsqlEpsgDatabase.forceReadOnly(directory);
            }
            catch (IOException file) {
                throw (SQLException)new SQLException("Can't read the SQL script.").initCause(file);
            }
        }
        return dataSource;
    }

    private static void generateData(DataSource dataSource) throws SQLException {
        Logging.getLogger(HsqlEpsgDatabase.class).config("Creating cached EPSG database.");
        try (Connection connection = dataSource.getConnection();
             Statement statement = connection.createStatement();){
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(HsqlEpsgDatabase.class.getResourceAsStream("EPSG.sql"), "ISO-8859-1"));
            StringBuilder insertStatement = null;
            while ((line = in.readLine()) != null) {
                int length = (line = line.trim()).length();
                if (length == 0) continue;
                if (line.startsWith("INSERT INTO")) {
                    insertStatement = new StringBuilder(line);
                    continue;
                }
                if (insertStatement != null) {
                    boolean hasMore;
                    int values = insertStatement.length();
                    insertStatement.append(line);
                    boolean bl = hasMore = line.charAt(length - 1) == ',';
                    if (hasMore) {
                        insertStatement.setLength(insertStatement.length() - 1);
                    }
                    line = insertStatement.toString();
                    insertStatement.setLength(values);
                    if (!hasMore) {
                        insertStatement = null;
                    }
                }
                statement.execute(line);
            }
            in.close();
        }
        catch (IOException exception) {
            SQLException e = new SQLException("Can't read the SQL script.");
            e.initCause(exception);
            throw e;
        }
    }

    private static void forceReadOnly(File directory) throws IOException {
        File file = new File(directory, "EPSG.properties");
        FileInputStream propertyIn = new FileInputStream(file);
        Properties properties = new Properties();
        properties.load(propertyIn);
        ((InputStream)propertyIn).close();
        properties.put("readonly", "true");
        FileOutputStream out = new FileOutputStream(file);
        properties.store(out, "EPSG database on HSQL");
        ((OutputStream)out).close();
    }

    static File getDirectory() throws SQLException {
        try {
            File directory;
            String property = System.getProperty(DIRECTORY_KEY);
            if (property != null && ((directory = new File(property)).isDirectory() || directory.mkdir())) {
                return directory;
            }
        }
        catch (SecurityException property) {
            // empty catch block
        }
        File directory = new File(System.getProperty("java.io.tmpdir", "."), "Geotools");
        if ((directory.isDirectory() || directory.mkdir()) && ((directory = new File(directory, "Databases/HSQL")).isDirectory() || directory.mkdirs())) {
            return directory;
        }
        throw new SQLException("Can't write to the database directory.");
    }

    static boolean dataExists(DataSource dataSource) throws SQLException {
        try (Connection connection = dataSource.getConnection();){
            boolean bl = HsqlEpsgDatabase.dataExists(connection);
            return bl;
        }
    }

    static boolean dataExists(Connection connection) throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        try (ResultSet tables = metaData.getTables(null, null, DATABASE_NAME + metaData.getSearchStringEscape() + "_%", new String[]{"TABLE"});){
            boolean bl = tables.next();
            return bl;
        }
    }
}

