/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.warp;

import com.sun.media.jai.util.PropertyGeneratorImpl;
import it.geosolutions.jaiext.utilities.ImageLayout2;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.Collections;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderedOp;
import javax.media.jai.Warp;
import javax.media.jai.operator.ConstantDescriptor;

class WarpPropertyGenerator
extends PropertyGeneratorImpl {
    public WarpPropertyGenerator() {
        super(new String[]{"ROI"}, new Class[]{ROI.class}, new Class[]{RenderedOp.class});
    }

    @Override
    public Object getProperty(String name, Object opNode) {
        this.validate(name, opNode);
        if (opNode instanceof RenderedOp && name.equalsIgnoreCase("roi")) {
            ROI srcROI;
            RenderedOp op = (RenderedOp)opNode;
            ParameterBlock pb = op.getParameterBlock();
            RenderedImage src = pb.getRenderedSource(0);
            Object property = src.getProperty("ROI");
            if (property == null || property.equals(Image.UndefinedProperty) || !(property instanceof ROI)) {
                if (pb.getObjectParameter(3) != null) {
                    property = pb.getObjectParameter(3);
                } else {
                    return Image.UndefinedProperty;
                }
            }
            if ((srcROI = (ROI)property).getBounds().isEmpty()) {
                return Image.UndefinedProperty;
            }
            Interpolation interp = (Interpolation)pb.getObjectParameter(1);
            Rectangle srcBounds = new Rectangle(src.getMinX(), src.getMinY(), src.getWidth(), src.getHeight());
            if (!srcBounds.contains(srcROI.getBounds())) {
                srcROI = srcROI.intersect(new ROIShape(srcBounds));
            }
            Warp warp = (Warp)pb.getObjectParameter(0);
            Rectangle dstBounds = op.getBounds();
            ImageLayout2 layout = new ImageLayout2(op);
            int minx = (int)srcBounds.getMinX();
            int miny = (int)srcBounds.getMinY();
            int w = (int)srcBounds.getWidth();
            int h = (int)srcBounds.getHeight();
            layout.setMinX(minx);
            layout.setMinY(miny);
            layout.setWidth(w);
            layout.setHeight(h);
            layout.setTileWidth(src.getTileWidth());
            layout.setTileHeight(src.getTileHeight());
            RenderingHints hints = op.getRenderingHints();
            hints.add(new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout));
            RenderedOp constantImage = ConstantDescriptor.create(new Float(w), new Float(h), new Byte[]{(byte)-1}, hints);
            BorderExtender extender = BorderExtender.createInstance(1);
            RenderingHints warpingHints = new RenderingHints(Collections.emptyMap());
            warpingHints.putAll((Map<?, ?>)op.getRenderingHints());
            ImageLayout2 targetLayout = new ImageLayout2(op);
            targetLayout.setColorModel(srcROI.getAsImage().getColorModel());
            targetLayout.setSampleModel(srcROI.getAsImage().getSampleModel());
            warpingHints.put(JAI.KEY_IMAGE_LAYOUT, targetLayout);
            warpingHints.put(JAI.KEY_BORDER_EXTENDER, extender);
            ParameterBlock paramBlock = new ParameterBlock();
            paramBlock.setSource(constantImage, 0);
            paramBlock.add(warp);
            paramBlock.add(interp);
            paramBlock.add(null);
            paramBlock.add(srcROI);
            RenderedOp roiImage = JAI.create("Warp", paramBlock, warpingHints);
            ROI dstROI = new ROI(roiImage, 1);
            if (!dstBounds.contains(dstROI.getBounds())) {
                dstROI = dstROI.intersect(new ROIShape(dstBounds));
            }
            return dstROI;
        }
        return Image.UndefinedProperty;
    }
}

