/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fixAddresses;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.plugins.fixAddresses.IOSMEntity;
import org.openstreetmap.josm.plugins.fixAddresses.IProblem;
import org.openstreetmap.josm.plugins.fixAddresses.ISolution;
import org.openstreetmap.josm.plugins.fixAddresses.ProblemType;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class AddressProblem
implements IProblem {
    private List<ISolution> solutions = null;
    private String description;
    private ProblemType type;
    private IOSMEntity source;

    public AddressProblem(IOSMEntity source, String description, List<ISolution> solutions, ProblemType type) {
        this.source = source;
        this.description = description;
        this.solutions = solutions;
        this.type = type;
    }

    public AddressProblem(IOSMEntity source, String description, List<ISolution> solutions) {
        this(source, description, solutions, ProblemType.Warning);
    }

    public AddressProblem(IOSMEntity source, String description) {
        this(source, description, null, ProblemType.Warning);
    }

    private void lazyCreateSolutions() {
        if (this.solutions == null) {
            this.solutions = new ArrayList<ISolution>();
        }
    }

    @Override
    public void addSolution(ISolution solution) {
        CheckParameterUtil.ensureParameterNotNull((Object)solution, (String)"solution");
        this.lazyCreateSolutions();
        this.solutions.add(solution);
    }

    @Override
    public void applySolution(ISolution solution) {
        CheckParameterUtil.ensureParameterNotNull((Object)solution, (String)"solution");
        solution.solve();
    }

    @Override
    public void clearSolutions() {
        if (this.solutions == null) {
            return;
        }
        this.solutions.clear();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<ISolution> getSolutions() {
        return this.solutions;
    }

    @Override
    public ProblemType getType() {
        return this.type;
    }

    @Override
    public void removeSolution(ISolution solution) {
        if (this.solutions == null) {
            throw new RuntimeException("Solution list is null");
        }
        if (this.solutions.size() == 0) {
            throw new RuntimeException("Solution list is empty");
        }
        CheckParameterUtil.ensureParameterNotNull((Object)solution, (String)"solution");
        this.solutions.remove(solution);
    }

    @Override
    public IOSMEntity getSource() {
        return this.source;
    }
}

