/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.selection;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class SelectModNodesAction
extends JosmAction {
    private Command lastCmd;

    public SelectModNodesAction() {
        super(I18n.tr((String)"Select last modified nodes", (Object[])new Object[0]), "selmodnodes", I18n.tr((String)"Select last modified nodes", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:selmodnodes", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{"Select last modified nodes"}), (int)90, (int)5005), true);
        this.putValue("help", HelpUtil.ht((String)"/Action/SelectLastModifiedNodes"));
    }

    public void actionPerformed(ActionEvent e) {
        DataSet ds = this.getLayerManager().getEditDataSet();
        if (ds != null) {
            Collection selection = ds.getSelected();
            ds.clearSelection(ds.getSelectedWays());
            Command cmd = null;
            int num = UndoRedoHandler.getInstance().getUndoCommands().size();
            if (num == 0) {
                return;
            }
            int k = 0;
            int idx = this.lastCmd != null && !selection.isEmpty() ? UndoRedoHandler.getInstance().getUndoCommands().lastIndexOf(this.lastCmd) : num;
            HashSet<Node> nodes = new HashSet<Node>(10);
            do {
                idx = idx > 0 ? --idx : num - 1;
                cmd = (Command)UndoRedoHandler.getInstance().getUndoCommands().get(idx);
                if (cmd.getAffectedDataSet() != ds) continue;
                Collection pp = cmd.getParticipatingPrimitives();
                nodes.clear();
                for (OsmPrimitive p : pp) {
                    if (!(p instanceof Node) || p.isDeleted() || p.isDisabled()) continue;
                    nodes.add((Node)p);
                }
                if (nodes.isEmpty() || ds.getSelectedNodes().containsAll(nodes)) continue;
                ds.setSelected(nodes);
                this.lastCmd = cmd;
                return;
            } while (++k < num);
            this.lastCmd = null;
        }
    }

    protected boolean listenToSelectionChange() {
        return false;
    }

    protected void updateEnabledState() {
        this.setEnabled(this.getLayerManager().getEditDataSet() != null);
    }
}

