/*
 * Decompiled with CFR 0.152.
 */
package tec.units.indriya.format;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.ParsePosition;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.format.ParserException;
import tec.units.indriya.AbstractQuantity;
import tec.units.indriya.AbstractUnit;
import tec.units.indriya.ComparableQuantity;
import tec.units.indriya.format.QuantityFormat;
import tec.units.indriya.format.SimpleUnitFormat;
import tec.units.indriya.quantity.NumberQuantity;
import tec.units.indriya.quantity.Quantities;

class DefaultQuantityFormat
extends QuantityFormat {
    private static final long serialVersionUID = 2758248665095734058L;

    DefaultQuantityFormat() {
    }

    public Appendable format(Quantity measure, Appendable dest) throws IOException {
        Unit unit = measure.getUnit();
        dest.append(measure.getValue().toString());
        if (measure.getUnit().equals(AbstractUnit.ONE)) {
            return dest;
        }
        dest.append(' ');
        return SimpleUnitFormat.getInstance().format(unit, dest);
    }

    @Override
    public ComparableQuantity<?> parse(CharSequence csq, ParsePosition cursor) throws ParserException {
        int endDecimal;
        int startDecimal;
        for (startDecimal = cursor.getIndex(); startDecimal < csq.length() && Character.isWhitespace(csq.charAt(startDecimal)); ++startDecimal) {
        }
        for (endDecimal = startDecimal + 1; endDecimal < csq.length() && !Character.isWhitespace(csq.charAt(endDecimal)); ++endDecimal) {
        }
        BigDecimal decimal = new BigDecimal(csq.subSequence(startDecimal, endDecimal).toString());
        cursor.setIndex(endDecimal + 1);
        Unit<?> unit = SimpleUnitFormat.getInstance().parse(csq, cursor);
        return Quantities.getQuantity(decimal, unit);
    }

    AbstractQuantity<?> parse(CharSequence csq, int index) throws ParserException {
        int endDecimal;
        int startDecimal;
        for (startDecimal = index; startDecimal < csq.length() && Character.isWhitespace(csq.charAt(startDecimal)); ++startDecimal) {
        }
        for (endDecimal = startDecimal + 1; endDecimal < csq.length() && !Character.isWhitespace(csq.charAt(endDecimal)); ++endDecimal) {
        }
        Double decimal = new Double(csq.subSequence(startDecimal, endDecimal).toString());
        Unit<?> unit = SimpleUnitFormat.getInstance().parse(csq, index);
        return NumberQuantity.of(decimal, unit);
    }

    @Override
    public ComparableQuantity<?> parse(CharSequence csq) throws ParserException {
        return this.parse(csq, new ParsePosition(0));
    }
}

