/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.geotools.data.DataStore;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.RemoteOWS;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.StyledLayerImpl;
import org.geotools.styling.UserLayer;
import org.geotools.util.Utilities;
import org.opengis.feature.simple.SimpleFeatureType;

public class UserLayerImpl
extends StyledLayerImpl
implements UserLayer {
    private DataStore inlineFeatureDatastore = null;
    private SimpleFeatureType inlineFeatureType = null;
    RemoteOWS remoteOWS;
    List<Style> styles = new ArrayList<Style>();
    List<FeatureTypeConstraint> constraints = new ArrayList<FeatureTypeConstraint>();

    @Override
    public RemoteOWS getRemoteOWS() {
        return this.remoteOWS;
    }

    @Override
    public DataStore getInlineFeatureDatastore() {
        return this.inlineFeatureDatastore;
    }

    @Override
    public SimpleFeatureType getInlineFeatureType() {
        return this.inlineFeatureType;
    }

    @Override
    public void setInlineFeatureDatastore(DataStore store) {
        this.inlineFeatureDatastore = store;
    }

    @Override
    public void setInlineFeatureType(SimpleFeatureType ft) {
        this.inlineFeatureType = ft;
    }

    @Override
    public void setRemoteOWS(RemoteOWS service) {
        this.remoteOWS = service;
    }

    @Override
    public List<FeatureTypeConstraint> layerFeatureConstraints() {
        return this.constraints;
    }

    @Override
    public FeatureTypeConstraint[] getLayerFeatureConstraints() {
        return this.constraints.toArray(new FeatureTypeConstraint[0]);
    }

    @Override
    public void setLayerFeatureConstraints(FeatureTypeConstraint[] array) {
        this.constraints.clear();
        this.constraints.addAll(Arrays.asList(array));
    }

    @Override
    public List<Style> userStyles() {
        return this.styles;
    }

    @Override
    public Style[] getUserStyles() {
        return this.styles.toArray(new Style[0]);
    }

    @Override
    public void setUserStyles(Style[] styles) {
        this.styles.clear();
        this.styles.addAll(Arrays.asList(styles));
    }

    @Override
    public void addUserStyle(Style style) {
        this.styles.add(style);
    }

    @Override
    public void accept(StyleVisitor visitor) {
        visitor.visit(this);
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth instanceof UserLayerImpl) {
            UserLayerImpl other = (UserLayerImpl)oth;
            if (!(Utilities.equals(this.inlineFeatureDatastore, other.inlineFeatureDatastore) && Utilities.equals(this.inlineFeatureType, other.inlineFeatureType) && Utilities.equals(this.remoteOWS, other.remoteOWS) && Utilities.equals(this.styles, other.styles))) {
                return false;
            }
            return Utilities.equals(this.constraints, other.constraints);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.inlineFeatureDatastore, this.inlineFeatureType, this.remoteOWS, this.styles, this.constraints);
    }
}

