/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import org.geotools.filter.visitor.NullExpressionVisitor;
import org.opengis.filter.And;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.BinaryLogicOperator;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.NativeFilter;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNil;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.opengis.filter.temporal.After;
import org.opengis.filter.temporal.AnyInteracts;
import org.opengis.filter.temporal.Before;
import org.opengis.filter.temporal.Begins;
import org.opengis.filter.temporal.BegunBy;
import org.opengis.filter.temporal.BinaryTemporalOperator;
import org.opengis.filter.temporal.During;
import org.opengis.filter.temporal.EndedBy;
import org.opengis.filter.temporal.Ends;
import org.opengis.filter.temporal.Meets;
import org.opengis.filter.temporal.MetBy;
import org.opengis.filter.temporal.OverlappedBy;
import org.opengis.filter.temporal.TContains;
import org.opengis.filter.temporal.TEquals;
import org.opengis.filter.temporal.TOverlaps;

public class AbstractFilterVisitor
implements FilterVisitor {
    private ExpressionVisitor expressionVisitor;

    public AbstractFilterVisitor() {
        this(new NullExpressionVisitor());
    }

    public AbstractFilterVisitor(ExpressionVisitor expressionVisitor) {
        this.expressionVisitor = expressionVisitor;
    }

    @Override
    public Object visit(IncludeFilter filter, Object data) {
        return data;
    }

    @Override
    public Object visit(ExcludeFilter filter, Object data) {
        return data;
    }

    @Override
    public Object visitNullFilter(Object data) {
        return null;
    }

    @Override
    public Object visit(PropertyIsBetween filter, Object data) {
        if (filter.getLowerBoundary() != null) {
            filter.getLowerBoundary().accept(this.expressionVisitor, data);
        }
        if (filter.getExpression() != null) {
            filter.getExpression().accept(this.expressionVisitor, data);
        }
        if (filter.getUpperBoundary() != null) {
            filter.getUpperBoundary().accept(this.expressionVisitor, data);
        }
        return filter;
    }

    protected Object visit(BinaryComparisonOperator filter, Object data) {
        if (this.expressionVisitor != null) {
            if (filter.getExpression1() != null) {
                filter.getExpression1().accept(this.expressionVisitor, data);
            }
            if (filter.getExpression2() != null) {
                filter.getExpression2().accept(this.expressionVisitor, data);
            }
        }
        return filter;
    }

    @Override
    public Object visit(PropertyIsEqualTo filter, Object data) {
        return this.visit((BinaryComparisonOperator)filter, data);
    }

    @Override
    public Object visit(PropertyIsNotEqualTo filter, Object data) {
        return this.visit((BinaryComparisonOperator)filter, data);
    }

    @Override
    public Object visit(PropertyIsLessThan filter, Object data) {
        return this.visit((BinaryComparisonOperator)filter, data);
    }

    @Override
    public Object visit(PropertyIsLessThanOrEqualTo filter, Object data) {
        return this.visit((BinaryComparisonOperator)filter, data);
    }

    @Override
    public Object visit(PropertyIsGreaterThan filter, Object data) {
        return this.visit((BinaryComparisonOperator)filter, data);
    }

    @Override
    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object data) {
        return this.visit((BinaryComparisonOperator)filter, data);
    }

    @Override
    public Object visit(BBOX filter, Object data) {
        return this.visit((BinarySpatialOperator)filter, data);
    }

    protected Object visit(BinarySpatialOperator filter, Object data) {
        if (this.expressionVisitor != null) {
            if (filter.getExpression1() != null) {
                filter.getExpression1().accept(this.expressionVisitor, data);
            }
            if (filter.getExpression2() != null) {
                filter.getExpression2().accept(this.expressionVisitor, data);
            }
        }
        return filter;
    }

    @Override
    public Object visit(Beyond filter, Object data) {
        return this.visit((BinarySpatialOperator)filter, data);
    }

    @Override
    public Object visit(Contains filter, Object data) {
        return this.visit((BinarySpatialOperator)filter, data);
    }

    @Override
    public Object visit(Crosses filter, Object data) {
        return this.visit((BinarySpatialOperator)filter, data);
    }

    @Override
    public Object visit(Disjoint filter, Object data) {
        return this.visit((BinarySpatialOperator)filter, data);
    }

    @Override
    public Object visit(DWithin filter, Object data) {
        return this.visit((BinarySpatialOperator)filter, data);
    }

    @Override
    public Object visit(Equals filter, Object data) {
        return this.visit((BinarySpatialOperator)filter, data);
    }

    @Override
    public Object visit(Intersects filter, Object data) {
        return this.visit((BinarySpatialOperator)filter, data);
    }

    @Override
    public Object visit(Overlaps filter, Object data) {
        return this.visit((BinarySpatialOperator)filter, data);
    }

    @Override
    public Object visit(Touches filter, Object data) {
        return this.visit((BinarySpatialOperator)filter, data);
    }

    @Override
    public Object visit(Within filter, Object data) {
        return this.visit((BinarySpatialOperator)filter, data);
    }

    @Override
    public Object visit(PropertyIsLike filter, Object data) {
        if (this.expressionVisitor != null && filter.getExpression() != null) {
            filter.getExpression().accept(this.expressionVisitor, null);
        }
        return filter;
    }

    protected Object visit(BinaryLogicOperator filter, Object data) {
        if (filter.getChildren() != null) {
            for (Filter child : filter.getChildren()) {
                child.accept(this, data);
            }
        }
        return filter;
    }

    @Override
    public Object visit(And filter, Object data) {
        return this.visit((BinaryLogicOperator)filter, data);
    }

    @Override
    public Object visit(Or filter, Object data) {
        return this.visit((BinaryLogicOperator)filter, data);
    }

    @Override
    public Object visit(Not filter, Object data) {
        if (filter.getFilter() != null) {
            filter.getFilter().accept(this, data);
        }
        return filter;
    }

    @Override
    public Object visit(PropertyIsNull filter, Object data) {
        if (this.expressionVisitor != null && filter.getExpression() != null) {
            filter.getExpression().accept(this.expressionVisitor, data);
        }
        return filter;
    }

    @Override
    public Object visit(PropertyIsNil filter, Object extraData) {
        if (this.expressionVisitor != null && filter.getExpression() != null) {
            filter.getExpression().accept(this.expressionVisitor, extraData);
        }
        return filter;
    }

    @Override
    public Object visit(Id filter, Object data) {
        return filter;
    }

    @Override
    public Object visit(After after, Object extraData) {
        return this.visit((BinaryTemporalOperator)after, extraData);
    }

    @Override
    public Object visit(AnyInteracts anyInteracts, Object extraData) {
        return this.visit((BinaryTemporalOperator)anyInteracts, extraData);
    }

    @Override
    public Object visit(Before before, Object extraData) {
        return this.visit((BinaryTemporalOperator)before, extraData);
    }

    @Override
    public Object visit(Begins begins, Object extraData) {
        return this.visit((BinaryTemporalOperator)begins, extraData);
    }

    @Override
    public Object visit(BegunBy begunBy, Object extraData) {
        return this.visit((BinaryTemporalOperator)begunBy, extraData);
    }

    @Override
    public Object visit(During during, Object extraData) {
        return this.visit((BinaryTemporalOperator)during, extraData);
    }

    @Override
    public Object visit(EndedBy endedBy, Object extraData) {
        return this.visit((BinaryTemporalOperator)endedBy, extraData);
    }

    @Override
    public Object visit(Ends ends, Object extraData) {
        return this.visit((BinaryTemporalOperator)ends, extraData);
    }

    @Override
    public Object visit(Meets meets, Object extraData) {
        return this.visit((BinaryTemporalOperator)meets, extraData);
    }

    @Override
    public Object visit(MetBy metBy, Object extraData) {
        return this.visit((BinaryTemporalOperator)metBy, extraData);
    }

    @Override
    public Object visit(OverlappedBy overlappedBy, Object extraData) {
        return this.visit((BinaryTemporalOperator)overlappedBy, extraData);
    }

    @Override
    public Object visit(TContains contains, Object extraData) {
        return this.visit((BinaryTemporalOperator)contains, extraData);
    }

    @Override
    public Object visit(TEquals equals, Object extraData) {
        return this.visit((BinaryTemporalOperator)equals, extraData);
    }

    @Override
    public Object visit(TOverlaps contains, Object extraData) {
        return this.visit((BinaryTemporalOperator)contains, extraData);
    }

    protected Object visit(BinaryTemporalOperator filter, Object data) {
        if (this.expressionVisitor != null) {
            if (filter.getExpression1() != null) {
                filter.getExpression1().accept(this.expressionVisitor, data);
            }
            if (filter.getExpression2() != null) {
                filter.getExpression2().accept(this.expressionVisitor, data);
            }
        }
        return filter;
    }

    public String toString() {
        String name = this.getClass().getSimpleName();
        return "AbstractFilterVisitor " + name + " [expressionVisitor=" + this.expressionVisitor + "]";
    }

    @Override
    public Object visit(NativeFilter filter, Object extraData) {
        return filter;
    }
}

