/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid.io.footprint;

import java.io.File;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.coverage.grid.io.footprint.FootprintGeometryProvider;
import org.geotools.coverage.grid.io.footprint.FootprintInsetPolicy;
import org.geotools.coverage.grid.io.footprint.MultiLevelROIGeometryProvider;
import org.geotools.coverage.grid.io.footprint.MultiLevelROIProvider;
import org.geotools.coverage.grid.io.footprint.SidecarFootprintProvider;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.util.URLs;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;

public class MultiLevelROIProviderFactory {
    private static final Logger LOGGER = Logging.getLogger(MultiLevelROIProviderFactory.class);
    public static final String SOURCE_PROPERTY = "footprint_source";
    public static final String TYPE_SIDECAR = "sidecar";
    public static final String TYPE_RASTER = "raster";
    public static final String TYPE_MULTIPLE_SIDECAR = "multisidecar";

    protected MultiLevelROIProviderFactory() {
    }

    public static MultiLevelROIProvider createFootprintProvider(File referenceFile) {
        return MultiLevelROIProviderFactory.createFootprintProvider(referenceFile, null);
    }

    public static MultiLevelROIProvider createFootprintProvider(File referenceFile, Geometry granuleBounds) {
        Utilities.ensureNonNull("referenceFile", referenceFile);
        File configDirectory = referenceFile.isDirectory() ? referenceFile : referenceFile.getParentFile();
        File configFile = new File(configDirectory, "footprints.properties");
        if (!configFile.exists()) {
            configFile = SidecarFootprintProvider.getAlternativeFile(configFile);
        }
        Properties properties = MultiLevelROIProviderFactory.initProperties(configFile);
        String source = (String)properties.get(SOURCE_PROPERTY);
        SidecarFootprintProvider provider = null;
        if (source != null && !TYPE_SIDECAR.equals(source)) {
            throw new IllegalArgumentException("Invalid source type, it should be a reference to a 'sidecar', but was '" + source + "' instead");
        }
        provider = new SidecarFootprintProvider(referenceFile);
        return MultiLevelROIProviderFactory.createProvider(provider, properties, granuleBounds);
    }

    protected static MultiLevelROIProvider createProvider(FootprintGeometryProvider provider, Properties properties, Geometry imposedGranuleBounds) {
        double inset = FootprintInsetPolicy.getInset(properties);
        FootprintInsetPolicy insetPolicy = FootprintInsetPolicy.getInsetPolicy(properties);
        return new MultiLevelROIGeometryProvider(provider, inset, insetPolicy, imposedGranuleBounds);
    }

    protected static Properties initProperties(File configFile) {
        Properties properties = null;
        if (configFile != null && configFile.exists()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Retrieving footprints properties from the specified config file: " + configFile.getAbsolutePath());
            }
            properties = CoverageUtilities.loadPropertiesFromURL(URLs.fileToUrl(configFile));
        } else {
            properties = new Properties();
        }
        return properties;
    }
}

