/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.photoadjust;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.gui.layer.geoimage.ImageEntry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class UntaggedGeoImageLayerAction
extends AbstractAction
implements Layer.LayerAction {
    public UntaggedGeoImageLayerAction() {
        super(I18n.tr((String)"New layer for untagged images", (Object[])new Object[0]), ImageProvider.get((String)"untaglayer"));
    }

    private static GeoImageLayer getSelectedLayer() {
        return (GeoImageLayer)LayerListDialog.getInstance().getModel().getSelectedLayers().get(0);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        GeoImageLayer layer = UntaggedGeoImageLayerAction.getSelectedLayer();
        if (layer != null) {
            ArrayList<ImageEntry> untagged = new ArrayList<ImageEntry>();
            List images = layer.getImages();
            for (int idx = images.size() - 1; idx >= 0; --idx) {
                ImageEntry img = (ImageEntry)images.get(idx);
                if (img.getPos() != null) continue;
                untagged.add(img);
                layer.getImageData().removeImage(img);
            }
            MainApplication.getLayerManager().addLayer((Layer)new GeoImageLayer(untagged, layer.getGpxLayer(), I18n.tr((String)"Untagged Images", (Object[])new Object[0]), layer.isUseThumbs()));
        }
    }

    private static boolean enabled(GeoImageLayer layer) {
        if (layer != null) {
            boolean hasNoPos = false;
            boolean hasPos = false;
            for (ImageEntry img : layer.getImages()) {
                if (img.getPos() == null) {
                    hasNoPos = true;
                } else {
                    hasPos = true;
                }
                if (!hasNoPos || !hasPos) continue;
                return true;
            }
        }
        return false;
    }

    public Component createMenuComponent() {
        JMenuItem toggleItem = new JMenuItem(this);
        toggleItem.setEnabled(UntaggedGeoImageLayerAction.enabled(UntaggedGeoImageLayerAction.getSelectedLayer()));
        return toggleItem;
    }

    public boolean supportLayers(List<Layer> layers) {
        return layers.size() == 1 && layers.get(0) instanceof GeoImageLayer;
    }
}

