/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tracer;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.LinkedList;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.plugins.tracer.ConnectWays;
import org.openstreetmap.josm.plugins.tracer.TracerServer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;
import org.xml.sax.SAXException;

class TracerAction
extends MapMode
implements MouseListener {
    private static final long serialVersionUID = 1L;
    protected boolean cancel;
    private boolean ctrl;
    private boolean alt;
    private boolean shift;
    protected TracerServer server = new TracerServer();

    public TracerAction() {
        super(I18n.tr((String)"Tracer", (Object[])new Object[0]), "tracer-sml", I18n.tr((String)"Tracer.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:tracer", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Tracer", (Object[])new Object[0])}), (int)84, (int)5003), TracerAction.getCursor());
    }

    public void enterMode() {
        if (!this.isEnabled()) {
            return;
        }
        super.enterMode();
        MainApplication.getMap().mapView.setCursor(TracerAction.getCursor());
        MainApplication.getMap().mapView.addMouseListener((MouseListener)this);
    }

    public void exitMode() {
        super.exitMode();
        MainApplication.getMap().mapView.removeMouseListener((MouseListener)this);
    }

    private static Cursor getCursor() {
        return ImageProvider.getCursor((String)"crosshair", (String)"tracer-sml");
    }

    protected void traceAsync(Point clickPoint) {
        this.cancel = false;
        final LatLon pos = MainApplication.getMap().mapView.getLatLon(clickPoint.x, clickPoint.y);
        try {
            PleaseWaitRunnable tracerTask = new PleaseWaitRunnable(I18n.tr((String)"Tracing", (Object[])new Object[0])){

                protected void realRun() throws SAXException {
                    TracerAction.this.traceSync(pos, this.progressMonitor.createSubTaskMonitor(-1, false));
                }

                protected void finish() {
                }

                protected void cancel() {
                    TracerAction.this.cancel();
                }
            };
            Thread executeTraceThread = new Thread((Runnable)tracerTask);
            executeTraceThread.start();
        }
        catch (Exception e) {
            Logging.error((Throwable)e);
        }
    }

    private void tagBuilding(Way way) {
        if (!this.alt) {
            way.put("building", "yes");
        }
        way.put("source", "cuzk:km");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceSync(LatLon pos, ProgressMonitor progressMonitor) {
        LinkedList<Object> commands = new LinkedList<Object>();
        progressMonitor.beginTask(null, 3);
        try {
            ArrayList<LatLon> coordList = this.server.trace(pos);
            if (coordList.size() == 0) {
                return;
            }
            DataSet ds = MainApplication.getLayerManager().getEditDataSet();
            Way way = new Way();
            Node firstNode = null;
            for (LatLon coord : coordList) {
                Node node = new Node(coord);
                if (firstNode == null) {
                    firstNode = node;
                }
                commands.add(new AddCommand(ds, (OsmPrimitive)node));
                way.addNode(node);
            }
            way.addNode(firstNode);
            this.tagBuilding(way);
            commands.add(new AddCommand(ds, (OsmPrimitive)way));
            if (!this.ctrl) {
                commands.add(ConnectWays.connect(way));
            }
            if (!commands.isEmpty()) {
                UndoRedoHandler.getInstance().add((Command)new SequenceCommand(I18n.tr((String)"Tracer building", (Object[])new Object[0]), commands));
                if (this.shift) {
                    ds.addSelected(new PrimitiveId[]{way});
                } else {
                    ds.setSelected(new PrimitiveId[]{way});
                }
            } else {
                System.out.println("Failed");
            }
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    public void cancel() {
        this.cancel = true;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!MainApplication.getMap().mapView.isActiveLayerDrawable()) {
            return;
        }
        this.requestFocusInMapView();
        this.updateKeyModifiers(e);
        if (e.getButton() == 1) {
            this.traceAsync(e.getPoint());
        }
    }

    protected void updateKeyModifiers(MouseEvent e) {
        this.ctrl = (e.getModifiers() & 2) != 0;
        this.alt = (e.getModifiers() & 0x28) != 0;
        this.shift = (e.getModifiers() & 1) != 0;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

