/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.hot.sds;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.hot.sds.SdsDiskAccessAction;
import org.openstreetmap.hot.sds.SdsParser;
import org.openstreetmap.hot.sds.SeparateDataStorePlugin;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.widgets.SwingFileChooser;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SdsLoadAction
extends SdsDiskAccessAction {
    private SeparateDataStorePlugin plugin;

    public SdsLoadAction(SeparateDataStorePlugin p) {
        super(I18n.tr((String)"Load...", (Object[])new Object[0]), "sds_load", I18n.tr((String)"Load separate data store data from a file.", (Object[])new Object[0]), null);
        this.plugin = p;
    }

    public void actionPerformed(ActionEvent e) {
        SwingFileChooser fc = SdsLoadAction.createAndOpenFileChooser(true, true, null);
        if (fc == null) {
            return;
        }
        File[] files = fc.getSelectedFiles();
        this.openFiles(Arrays.asList(files));
    }

    public void openFiles(List<File> fileList) {
        OpenFileTask task = new OpenFileTask(fileList, this.plugin);
        MainApplication.worker.submit((Runnable)((Object)task));
    }

    public class OpenFileTask
    extends PleaseWaitRunnable {
        private List<File> files;
        private boolean canceled;
        private SeparateDataStorePlugin plugin;

        public OpenFileTask(List<File> files, SeparateDataStorePlugin p) {
            super(I18n.tr((String)"Loading files", (Object[])new Object[0]), false);
            this.files = new ArrayList<File>(files);
            this.plugin = p;
        }

        protected void cancel() {
            this.canceled = true;
        }

        protected void finish() {
        }

        protected void realRun() throws SAXException, IOException, OsmTransferException {
            if (this.files == null || this.files.isEmpty()) {
                return;
            }
            this.getProgressMonitor().setTicksCount(this.files.size());
            for (File f : this.files) {
                if (this.canceled) {
                    return;
                }
                this.getProgressMonitor().indeterminateSubTask(I18n.tr((String)"Opening file ''{0}'' ...", (Object[])new Object[]{f.getAbsolutePath()}));
                try {
                    FileInputStream fileStream = new FileInputStream(f);
                    SdsParser p = new SdsParser(SdsLoadAction.this.getLayerManager().getEditDataSet(), this.plugin, false);
                    InputSource inputSource = new InputSource(fileStream);
                    SAXParserFactory.newInstance().newSAXParser().parse(inputSource, (DefaultHandler)p);
                }
                catch (IOException | ParserConfigurationException | SAXException e) {
                    Logging.error((Throwable)e);
                }
            }
        }
    }
}

