/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.surveyor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.dinopolis.util.io.Tokenizer;
import org.openstreetmap.josm.plugins.surveyor.GpsActionEvent;
import org.openstreetmap.josm.plugins.surveyor.SurveyorAction;
import org.openstreetmap.josm.plugins.surveyor.SurveyorActionFactory;
import org.openstreetmap.josm.tools.Logging;

public class SurveyorActionDescription {
    private String actionClass;
    private List<String> params;
    private SurveyorAction action;

    public SurveyorActionDescription() {
    }

    public SurveyorActionDescription(String actionClass) {
        this.actionClass = actionClass;
    }

    public SurveyorActionDescription(String actionClass, List<String> params) {
        this.actionClass = actionClass;
        this.params = params;
    }

    public SurveyorActionDescription(String actionClass, String[] params) {
        this.actionClass = actionClass;
        this.params = new ArrayList<String>();
        for (int index = 0; index < params.length; ++index) {
            this.params.add(params[index]);
        }
    }

    public String getActionClass() {
        return this.actionClass;
    }

    public void setActionClass(String actionClass) {
        this.actionClass = actionClass;
    }

    public List<String> getParameterList() {
        return this.params;
    }

    public void setParameterList(List<String> params) {
        this.params = params;
    }

    public void actionPerformed(GpsActionEvent e) {
        if (this.action == null) {
            this.action = SurveyorActionFactory.getInstance(this.actionClass);
            this.action.setParameters(this.getParameterList());
        }
        this.action.actionPerformed(e);
    }

    public void setClass_(String claszName) {
        this.setActionClass(claszName);
    }

    public void setParams(String paramString) {
        Tokenizer tokenizer = new Tokenizer(paramString, ",");
        try {
            this.params = tokenizer.nextLine();
        }
        catch (IOException ignore) {
            Logging.debug((Throwable)ignore);
        }
    }
}

