/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.photoadjust;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.Action;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.photoadjust.PhotoAdjustMapMode;
import org.openstreetmap.josm.plugins.photoadjust.PhotoAdjustWorker;
import org.openstreetmap.josm.plugins.photoadjust.PhotoPropertyEditor;
import org.openstreetmap.josm.plugins.photoadjust.UntaggedGeoImageLayerAction;

public class PhotoAdjustPlugin
extends Plugin
implements MainLayerManager.ActiveLayerChangeListener {
    private GeoImageLayer imageLayer;
    private MouseAdapter mouseAdapter;
    private MouseMotionAdapter mouseMotionAdapter;
    private final PhotoAdjustWorker worker = new PhotoAdjustWorker();

    public PhotoAdjustPlugin(PluginInformation info) {
        super(info);
        GeoImageLayer.registerMenuAddition((Action)new UntaggedGeoImageLayerAction());
        PhotoPropertyEditor.init();
        this.initAdapters();
    }

    private void initAdapters() {
        this.mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (PhotoAdjustPlugin.this.imageLayer != null) {
                    ArrayList<GeoImageLayer> layers = new ArrayList<GeoImageLayer>(1);
                    layers.add(PhotoAdjustPlugin.this.imageLayer);
                    PhotoAdjustPlugin.this.worker.doMousePressed(evt, layers);
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (PhotoAdjustPlugin.this.imageLayer != null) {
                    PhotoAdjustPlugin.this.worker.doMouseReleased(evt);
                }
            }
        };
        this.mouseMotionAdapter = new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                PhotoAdjustPlugin.this.worker.doMouseDragged(evt);
            }
        };
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (oldFrame == null && newFrame != null) {
            MainApplication.getLayerManager().addAndFireActiveLayerChangeListener((MainLayerManager.ActiveLayerChangeListener)this);
            PhotoAdjustMapMode adjustMode = new PhotoAdjustMapMode(this.worker);
            adjustMode.installMapMode(newFrame);
        } else {
            MainApplication.getLayerManager().removeActiveLayerChangeListener((MainLayerManager.ActiveLayerChangeListener)this);
        }
    }

    public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
        this.worker.reset();
        Layer oldLayer = e.getPreviousActiveLayer();
        Layer newLayer = MainApplication.getLayerManager().getActiveLayer();
        if (oldLayer instanceof GeoImageLayer && newLayer instanceof GeoImageLayer) {
            this.imageLayer = (GeoImageLayer)newLayer;
        } else {
            if (oldLayer instanceof GeoImageLayer) {
                MainApplication.getMap().mapView.removeMouseListener((MouseListener)this.mouseAdapter);
                MainApplication.getMap().mapView.removeMouseMotionListener((MouseMotionListener)this.mouseMotionAdapter);
                this.imageLayer = null;
            }
            if (newLayer instanceof GeoImageLayer) {
                this.imageLayer = (GeoImageLayer)newLayer;
                MainApplication.getMap().mapView.addMouseListener((MouseListener)this.mouseAdapter);
                MainApplication.getMap().mapView.addMouseMotionListener((MouseMotionListener)this.mouseMotionAdapter);
            }
        }
    }
}

