/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.piclayer.gui.autocalibrate;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;

public class SelectLayerView {
    private String[] labels = new String[10];
    private JList<?> list;
    private JFrame frame;
    private JScrollPane scrollPane;
    private JPanel buttonBar;
    private JButton okButton;
    private JButton cancelButton;
    private Container contentPane;

    public SelectLayerView() {
        this.getLayerNames();
        this.list = new JList<String>(this.labels);
        this.frame = new JFrame("Layer Selector");
        this.frame.setSize(400, 200);
        this.frame.setLocationRelativeTo(this.frame.getOwner());
        this.contentPane = this.frame.getContentPane();
        this.setScrollPane();
        this.contentPane.add((Component)this.scrollPane, "Center");
        this.setButtonBar();
        this.setOKButton();
        this.setCancelButton();
        this.contentPane.add((Component)this.buttonBar, "South");
    }

    private void getLayerNames() {
        List layer = MainApplication.getLayerManager().getLayers();
        for (int i = 0; i < layer.size(); ++i) {
            this.labels[i] = ((Layer)layer.get(i)).getName();
        }
    }

    public void setVisible(boolean value) {
        this.frame.setVisible(value);
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public JList<?> getList() {
        return this.list;
    }

    private void setScrollPane() {
        this.scrollPane = new JScrollPane(this.list);
    }

    private void setButtonBar() {
        this.buttonBar = new JPanel();
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 85, 80};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
    }

    private void setOKButton() {
        this.okButton = new JButton();
        this.okButton.setText(I18n.tr((String)"OK", (Object[])new Object[0]));
        this.buttonBar.add((Component)this.okButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
    }

    private void setCancelButton() {
        this.cancelButton = new JButton();
        this.cancelButton.setText(I18n.tr((String)"Cancel", (Object[])new Object[0]));
        this.buttonBar.add((Component)this.cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void setOkButtonListener(ActionListener l) {
        this.okButton.addActionListener(l);
    }

    public void setCancelButtonListener(ActionListener l) {
        this.cancelButton.addActionListener(l);
    }
}

