/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.record.formula.AbstractFunctionPtg;
import org.apache.poi.hssf.record.formula.function.FunctionMetadata;
import org.apache.poi.hssf.record.formula.function.FunctionMetadataRegistry;
import org.apache.poi.util.LittleEndianInput;
import org.apache.poi.util.LittleEndianOutput;

public final class FuncPtg
extends AbstractFunctionPtg {
    public static final byte sid = 33;
    public static final int SIZE = 3;

    public static FuncPtg create(LittleEndianInput littleEndianInput) {
        return FuncPtg.create(littleEndianInput.readUShort());
    }

    private FuncPtg(int n, FunctionMetadata functionMetadata) {
        super(n, functionMetadata.getReturnClassCode(), functionMetadata.getParameterClassCodes(), functionMetadata.getMinParams());
    }

    public static FuncPtg create(int n) {
        FunctionMetadata functionMetadata = FunctionMetadataRegistry.getFunctionByIndex(n);
        if (functionMetadata == null) {
            throw new RuntimeException("Invalid built-in function index (" + n + ")");
        }
        return new FuncPtg(n, functionMetadata);
    }

    @Override
    public void write(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeByte(33 + this.getPtgClass());
        littleEndianOutput.writeShort(this.getFunctionIndex());
    }

    @Override
    public int getSize() {
        return 3;
    }
}

