/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.JunctionChecker;

import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.plugins.JunctionChecker.JunctionCheckerPlugin;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.Channel;
import org.openstreetmap.josm.plugins.JunctionChecker.junctionchecking.JunctionChecker;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class JunctionCheckTask
extends PleaseWaitRunnable {
    private final JunctionChecker jc;
    private final JunctionCheckerPlugin plugin;
    private final int n;
    private final HashSet<Channel> subset;
    private final boolean produceRelation;
    private boolean canceled;

    public JunctionCheckTask(JunctionCheckerPlugin plugin, int n, HashSet<Channel> subset, boolean produceRelation) {
        super("JunctionCheck", false);
        this.plugin = plugin;
        this.n = n;
        this.subset = subset;
        this.produceRelation = produceRelation;
        this.jc = new JunctionChecker(plugin.getChannelDigraph(), n);
    }

    protected void cancel() {
        this.canceled = true;
        this.progressMonitor.cancel();
    }

    protected void finish() {
        if (this.canceled) {
            return;
        }
        this.progressMonitor.finishTask();
        if (this.jc.isSmallerJunction()) {
            this.showjunction();
            JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"The marked channels contains a junctioncandidate (white). To test this candidat mark these channel and press the \"Check\" button again.", (Object[])new Object[0]));
        } else if (this.jc.getCheck()) {
            this.showjunction();
            JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"The marked channels are a {0}-ways junction", (Object[])new Object[]{this.n}));
            this.plugin.getChannelDigraph().ereaseJunctioncandidate();
            for (int i = 0; i < this.jc.getSubJunction().size(); ++i) {
                this.plugin.getChannelDigraph().addJunctioncandidateChannel(this.jc.getSubJunction().get(i));
            }
            if (this.produceRelation) {
                this.plugin.getRelationProducer().produceRelation(this.subset, this.n);
            }
        } else if (!this.jc.getCheck()) {
            JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"The marked channels are not a junction:", (Object[])new Object[0]) + this.jc.getJCheckResult());
        }
    }

    protected void realRun() throws SAXException, IOException, OsmTransferException {
        this.jc.checkjunctions(new ArrayList<Channel>(this.subset), this.getProgressMonitor());
    }

    public JunctionChecker getJunctionChecker() {
        return this.jc;
    }

    private void showjunction() {
        this.plugin.getChannelDigraph().ereaseJunctioncandidate();
        for (int i = 0; i < this.jc.getSubJunction().size(); ++i) {
            this.plugin.getChannelDigraph().addJunctioncandidateChannel(this.jc.getSubJunction().get(i));
        }
        MainApplication.getLayerManager().setActiveLayer((Layer)this.plugin.getChannelDigraphLayer());
    }
}

