/*
 * Decompiled with CFR 0.152.
 */
package tec.units.indriya.quantity;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Objects;
import javax.measure.Quantity;
import javax.measure.Unit;
import tec.units.indriya.AbstractQuantity;
import tec.units.indriya.ComparableQuantity;
import tec.units.indriya.quantity.NumberQuantity;

final class IntegerQuantity<Q extends Quantity<Q>>
extends AbstractQuantity<Q> {
    private static final long serialVersionUID = 1405915111744728289L;
    final int value;

    public IntegerQuantity(int value, Unit<Q> unit) {
        super(unit);
        this.value = value;
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    @Override
    public double doubleValue(Unit<Q> unit) {
        return super.getUnit().equals(unit) ? (double)this.value : super.getUnit().getConverterTo(unit).convert(this.value);
    }

    @Override
    public long longValue(Unit<Q> unit) {
        double result = this.doubleValue(unit);
        if (result < -9.223372036854776E18 || result > 9.223372036854776E18) {
            throw new ArithmeticException("Overflow (" + result + ")");
        }
        return (long)result;
    }

    @Override
    public ComparableQuantity<Q> add(Quantity<Q> that) {
        Quantity<Q> converted = that.to(this.getUnit());
        return NumberQuantity.of(this.value + converted.getValue().intValue(), this.getUnit());
    }

    @Override
    public ComparableQuantity<Q> subtract(Quantity<Q> that) {
        Quantity<Q> converted = that.to(this.getUnit());
        return NumberQuantity.of(this.value - converted.getValue().intValue(), this.getUnit());
    }

    @Override
    public ComparableQuantity<?> multiply(Quantity<?> that) {
        return new IntegerQuantity(this.value * that.getValue().intValue(), this.getUnit().multiply(that.getUnit()));
    }

    @Override
    public ComparableQuantity<Q> multiply(Number that) {
        return NumberQuantity.of(this.value * that.intValue(), this.getUnit());
    }

    @Override
    public ComparableQuantity<?> divide(Quantity<?> that) {
        return NumberQuantity.of((double)this.value / that.getValue().doubleValue(), this.getUnit().divide(that.getUnit()));
    }

    @Override
    public AbstractQuantity<Q> inverse() {
        return NumberQuantity.of(1 / this.value, this.getUnit().inverse());
    }

    @Override
    public ComparableQuantity<Q> divide(Number that) {
        return NumberQuantity.of((double)this.value / that.doubleValue(), this.getUnit());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof Quantity) {
            Quantity that = (Quantity)obj;
            return Objects.equals(this.getUnit(), that.getUnit()) && AbstractQuantity.Equalizer.hasEquality(this.value, that.getValue());
        }
        return false;
    }

    @Override
    public boolean isBig() {
        return false;
    }

    @Override
    public BigDecimal decimalValue(Unit<Q> unit, MathContext ctx) throws ArithmeticException {
        return null;
    }
}

