/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.curves;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.plugins.utilsplugin2.curves.CircleArcMaker;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Shortcut;

public class CurveAction
extends JosmAction {
    private static final long serialVersionUID = 1L;

    public CurveAction() {
        super(I18n.tr((String)"Circle arc", (Object[])new Object[0]), "circlearc", I18n.tr((String)"Create a circle arc", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:createcurve", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Create a circle arc", (Object[])new Object[0])}), (int)67, (int)5005), true);
        this.putValue("help", HelpUtil.ht((String)"/Action/CreateCircleArc"));
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        ArrayList<Node> selectedNodes = new ArrayList<Node>(this.getLayerManager().getEditDataSet().getSelectedNodes());
        ArrayList<Way> selectedWays = new ArrayList<Way>(this.getLayerManager().getEditDataSet().getSelectedWays());
        String msg = null;
        try {
            Collection<Command> cmds = CircleArcMaker.doCircleArc(selectedNodes, selectedWays);
            if (cmds == null || cmds.isEmpty()) {
                msg = I18n.tr((String)"Could not use selection to create a curve", (Object[])new Object[0]);
            } else {
                UndoRedoHandler.getInstance().add((Command)new SequenceCommand("Create a curve", cmds));
            }
        }
        catch (JosmRuntimeException ex) {
            msg = I18n.tr((String)"Could not use selection to create a curve: {0}", (Object[])new Object[]{ex.getMessage()});
        }
        if (msg != null) {
            new Notification(msg).setIcon(2).show();
        }
    }

    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }
}

